/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.web;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.common.ConfigSet;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.UCB;
import com.sun.star.wizards.ui.event.Task;
import com.sun.star.wizards.web.ErrorHandler;
import com.sun.star.wizards.web.ExtensionVerifier;
import com.sun.star.wizards.web.ProcessErrors;
import com.sun.star.wizards.web.WebWizardConst;
import com.sun.star.wizards.web.data.CGContent;
import com.sun.star.wizards.web.data.CGDocument;
import com.sun.star.wizards.web.data.CGExporter;
import com.sun.star.wizards.web.data.CGLayout;
import com.sun.star.wizards.web.data.CGPublish;
import com.sun.star.wizards.web.data.CGSettings;
import com.sun.star.wizards.web.export.Exporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class Process
implements WebWizardConst,
ProcessErrors {
    private static final int TASKS_PER_DOC = 5;
    private static final int TASKS_PER_XSL = 2;
    private static final int TASKS_PER_PUBLISH = 2;
    private static final int TASKS_IN_PREPARE = 1;
    private static final int TASKS_IN_EXPORT = 2;
    private static final int TASKS_IN_GENERATE = 2;
    private static final int TASKS_IN_PUBLISH = 2;
    private static final int TASKS_IN_FINISHUP = 1;
    private CGSettings settings;
    private XMultiServiceFactory xmsf;
    private ErrorHandler errorHandler;
    private String tempDir;
    private FileAccess fileAccess;
    private UCB ucb;
    public Task myTask;
    private Map exporters = new Hashtable(3);
    private boolean result;

    public Process(CGSettings cGSettings, XMultiServiceFactory xMultiServiceFactory, ErrorHandler errorHandler) throws Exception {
        this.xmsf = xMultiServiceFactory;
        this.settings = cGSettings;
        this.fileAccess = new FileAccess(xMultiServiceFactory);
        this.errorHandler = errorHandler;
        this.ucb = new UCB(xMultiServiceFactory);
        int n = this.getTaskSteps();
        this.myTask = new Task("WWIZ", "t-prep", n);
    }

    private int countPublish() {
        int n = 0;
        ConfigSet configSet = this.settings.cp_DefaultSession.cp_Publishing;
        for (int i = 0; i < configSet.getSize(); ++i) {
            if (!((CGPublish)((Object)configSet.getElementAt((int)i))).cp_Publish) continue;
            ++n;
        }
        return n;
    }

    private int getTaskSteps() {
        int n = this.settings.cp_DefaultSession.cp_Content.cp_Documents.getSize();
        int n2 = 0;
        try {
            n2 = this.settings.cp_DefaultSession.getLayout().getTemplates(this.xmsf).size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = this.countPublish();
        return 3 + n * 5 + 2 + n2 * 2 + 2 + n3 * 2 + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runProcess() {
        this.myTask.start();
        try {
            try {
                this.result = this.createTempDir(this.myTask) && this.export(this.myTask) && this.generate(this.tempDir, this.myTask) && this.publish(this.tempDir, this.myTask);
            }
            finally {
                this.result &= this.cleanup(this.myTask);
            }
        }
        catch (Exception exception) {
            this.result = false;
        }
        if (!this.result) {
            this.myTask.fail();
        }
        while (this.myTask.getStatus() < this.myTask.getMax()) {
            this.myTask.advance(true);
        }
    }

    private boolean createTempDir(Task task) {
        this.tempDir = this.fileAccess.createNewDir(Process.getSOTempDir(this.xmsf), "wwiztemp");
        if (this.tempDir == null) {
            this.error(null, null, 0, 1);
            return false;
        }
        task.advance(true);
        return true;
    }

    static String getSOTempDir(XMultiServiceFactory xMultiServiceFactory) {
        try {
            return FileAccess.getOfficePath((XMultiServiceFactory)xMultiServiceFactory, (String)"Temp", (String)PropertyNames.EMPTY_STRING, (String)PropertyNames.EMPTY_STRING);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean cleanup(Task task) {
        task.setSubtaskName("t_fin");
        boolean bl = this.fileAccess.delete(this.tempDir);
        if (!bl) {
            this.error(null, null, 10, 8);
        }
        task.advance(bl);
        return bl;
    }

    public static void copyMedia(UCB uCB, CGSettings cGSettings, String string, Task task) throws Exception {
        String string2 = FileAccess.connectURLs((String)cGSettings.workPath, (String)"styles");
        String string3 = cGSettings.cp_DefaultSession.getStyle().cp_CssHref;
        uCB.copy(string2, string3, string, "style.css");
        task.advance(true);
        String string4 = cGSettings.cp_DefaultSession.cp_Design.cp_BackgroundImage;
        if (string4 != null && !string4.equals(PropertyNames.EMPTY_STRING)) {
            string2 = FileAccess.getParentDir((String)string4);
            string3 = string4.substring(string2.length());
            uCB.copy(string2, string3, string + "/images", "background.gif");
        }
        task.advance(true);
    }

    public static void copyStaticImages(UCB uCB, CGSettings cGSettings, String string) throws Exception {
        uCB.copy(FileAccess.connectURLs((String)cGSettings.workPath, (String)"images"), string + "/images");
    }

    private boolean publish(String string, Task task) {
        task.setSubtaskName("t_pub_prep");
        ConfigSet configSet = this.settings.cp_DefaultSession.cp_Publishing;
        try {
            Process.copyMedia(this.ucb, this.settings, string, task);
            Process.copyStaticImages(this.ucb, this.settings, string);
            task.advance(true);
        }
        catch (Exception exception) {
            this.error(exception, PropertyNames.EMPTY_STRING, 9, 1);
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < configSet.getSize(); ++i) {
            CGPublish cGPublish = (CGPublish)((Object)configSet.getElementAt(i));
            if (!cGPublish.cp_Publish) continue;
            String string2 = (String)configSet.getKey((Object)cGPublish);
            task.setSubtaskName(string2);
            if (string2.equals("zip")) {
                this.fileAccess.delete(cGPublish.cp_URL);
            }
            if (this.publish(string, cGPublish, this.ucb, task)) continue;
            return false;
        }
        return bl;
    }

    private boolean publish(String string, CGPublish cGPublish, UCB uCB, Task task) {
        try {
            task.advance(true);
            uCB.copy(string, cGPublish.url);
            task.advance(true);
            return true;
        }
        catch (Exception exception) {
            task.advance(false);
            return this.error(exception, (Object)cGPublish, 8, 3);
        }
    }

    public boolean generate(String string, Task task) {
        boolean bl = false;
        task.setSubtaskName("t_gen_prep");
        CGLayout cGLayout = this.settings.cp_DefaultSession.getLayout();
        try {
            Document document = (Document)this.settings.cp_DefaultSession.createDOM();
            Process.generate(this.xmsf, cGLayout, document, this.fileAccess, string, task);
        }
        catch (Exception exception) {
            this.error(exception, PropertyNames.EMPTY_STRING, 6, 1);
            return false;
        }
        try {
            task.setSubtaskName("t_gen_cp");
            Process.copyLayoutFiles(this.ucb, this.fileAccess, this.settings, cGLayout, string);
            task.advance(true);
            bl = true;
        }
        catch (Exception exception) {
            task.advance(false);
            return this.error(exception, null, 7, 2);
        }
        return bl;
    }

    public static void copyLayoutFiles(UCB uCB, FileAccess fileAccess, CGSettings cGSettings, CGLayout cGLayout, String string) throws Exception {
        String string2 = fileAccess.getURL(FileAccess.connectURLs((String)cGSettings.workPath, (String)"layouts/"), cGLayout.cp_FSName);
        uCB.copy(string2, string, (UCB.Verifier)new ExtensionVerifier("xsl"));
    }

    public static void generate(XMultiServiceFactory xMultiServiceFactory, CGLayout cGLayout, Document document, FileAccess fileAccess, String string, Task task) throws Exception {
        Map map = cGLayout.getTemplates(xMultiServiceFactory);
        task.advance(true, "t_gen_x");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = PropertyNames.EMPTY_STRING;
            string2 = (String)iterator.next();
            Transformer transformer = ((Templates)map.get(string2)).newTransformer();
            document.normalize();
            task.advance(true);
            String string3 = fileAccess.getPath(string, string2.substring(0, string2.length() - 4));
            File file = new File(string3);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            transformer.transform(new DOMSource(document), new StreamResult(fileOutputStream));
            fileOutputStream.close();
            task.advance(true);
        }
    }

    private boolean export(Task task) {
        return this.export(this.settings.cp_DefaultSession.cp_Content, this.tempDir, task);
    }

    private boolean export(CGContent cGContent, String string, Task task) {
        int n = 1;
        String string2 = string;
        try {
            task.setSubtaskName("t_exp_prep");
            string2 = this.fileAccess.createNewDir(string, cGContent.cp_Name);
            if (string2 == null || string2.equals(PropertyNames.EMPTY_STRING)) {
                throw new IOException("Directory " + string + " could not be created.");
            }
            cGContent.dirName = FileAccess.getFilename((String)string2);
            task.advance(true, "t_exp_docs");
            --n;
            Object object = null;
            for (int i = 0; i < cGContent.cp_Documents.getSize(); ++i) {
                try {
                    object = cGContent.cp_Documents.getElementAt(i);
                    if (!(object instanceof CGDocument ? !this.export((CGDocument)((Object)object), string2, task) : !this.export((CGContent)((Object)object), string2, task))) continue;
                    return false;
                }
                catch (SecurityException securityException) {
                    if (!this.error(securityException, object, 5, 3)) {
                        return false;
                    }
                    this.result = false;
                }
            }
        }
        catch (IOException iOException) {
            return this.error(iOException, (Object)cGContent, 4, 3);
        }
        catch (SecurityException securityException) {
            return this.error(securityException, (Object)cGContent, 5, 3);
        }
        this.failTask(task, n);
        return true;
    }

    private boolean export(CGDocument cGDocument, String string, Task task) {
        block9: {
            if (!cGDocument.valid) {
                try {
                    cGDocument.validate(this.xmsf, null);
                }
                catch (Exception exception) {
                    this.error(exception, (Object)cGDocument, 3, 1);
                    return false;
                }
            }
            CGExporter cGExporter = (CGExporter)((Object)this.settings.cp_Exporters.getElement((Object)cGDocument.cp_Exporter));
            try {
                String string2;
                String string3 = FileAccess.getFilename((String)cGDocument.cp_URL);
                String string4 = FileAccess.getExtension((String)string3);
                String string5 = cGDocument.localFilename.substring(0, cGDocument.localFilename.length() - string4.length() - 1);
                String string6 = string2 = cGExporter.cp_Extension.equals(PropertyNames.EMPTY_STRING) ? FileAccess.getExtension((String)string3) : cGExporter.cp_Extension;
                if (cGExporter.cp_OwnDirectory) {
                    string = this.fileAccess.createNewDir(string, string5);
                    cGDocument.dirName = FileAccess.getFilename((String)string);
                }
                String string7 = this.fileAccess.getNewFile(string, string5, string2);
                cGDocument.urlFilename = FileAccess.getFilename((String)string7);
                task.advance(true);
                try {
                    this.getExporter(cGExporter).export(cGDocument, string7, this.xmsf, task);
                    task.advance(true);
                }
                catch (Exception exception) {
                    if (!this.error(exception, (Object)cGDocument, 1, 3)) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                if (this.error(exception, (Object)cGDocument, 2, 2)) break block9;
                return false;
            }
        }
        return true;
    }

    private boolean error(Exception exception, Object object, int n, int n2) {
        this.result = false;
        return this.errorHandler.error(exception, object, n, n2);
    }

    private void failTask(Task task, int n) {
        while (n-- > 0) {
            task.advance(false);
        }
    }

    private Exporter createExporter(CGExporter cGExporter) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Exporter exporter = (Exporter)Class.forName(cGExporter.cp_ExporterClass).newInstance();
        exporter.init(cGExporter);
        return exporter;
    }

    private Exporter getExporter(CGExporter cGExporter) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Exporter exporter = (Exporter)this.exporters.get((Object)cGExporter);
        if (exporter == null) {
            exporter = this.createExporter(cGExporter);
            this.exporters.put(cGExporter, exporter);
        }
        return exporter;
    }

    public boolean getResult() {
        return this.myTask.getFailed() == 0 && this.result;
    }
}

