/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class Mode
implements Serializable {
    public static final int DEFAULT_MODE = -1;
    public static final int NAMED_MODE = -3;
    public static final int STRIPPER_MODE = -4;
    public static final StructuredQName ALL_MODES = new StructuredQName("saxon", "http://saxon.sf.net/", "_omniMode");
    public static final StructuredQName DEFAULT_MODE_NAME = new StructuredQName("saxon", "http://saxon.sf.net/", "_defaultMode");
    private Rule[] ruleDict = new Rule[114];
    private Rule mostRecentRule;
    private boolean isDefault;
    private boolean isStripper;
    private boolean hasRules = false;
    private StructuredQName modeName;

    public Mode(int usage, StructuredQName modeName) {
        this.isDefault = usage == -1;
        this.isStripper = usage == -4;
        this.modeName = modeName;
    }

    public Mode(Mode omniMode, StructuredQName modeName) {
        this.isDefault = false;
        this.isStripper = false;
        this.modeName = modeName;
        if (omniMode != null) {
            for (int i = 0; i < this.ruleDict.length; ++i) {
                if (omniMode.ruleDict[i] == null) continue;
                this.ruleDict[i] = new Rule(omniMode.ruleDict[i]);
            }
            this.mostRecentRule = omniMode.mostRecentRule;
        }
    }

    public boolean isDefaultMode() {
        return this.isDefault;
    }

    public StructuredQName getModeName() {
        return this.modeName;
    }

    public boolean isEmpty() {
        return !this.hasRules;
    }

    public void addRule(Pattern p, Object action, int precedence, double priority, boolean explicitMode) {
        Rule newRule;
        if (explicitMode) {
            this.hasRules = true;
        }
        if (p.getNodeTest() instanceof EmptySequenceTest) {
            return;
        }
        int fingerprint = p.getFingerprint();
        int type = p.getNodeKind();
        int key = this.getList(fingerprint, type);
        int sequence = this.mostRecentRule == null ? 0 : (action == this.mostRecentRule.getAction() ? this.mostRecentRule.getSequence() : this.mostRecentRule.getSequence() + 1);
        this.mostRecentRule = newRule = new Rule(p, action, precedence, priority, sequence);
        Rule rule = this.ruleDict[key];
        if (rule == null) {
            this.ruleDict[key] = newRule;
            return;
        }
        Rule prev = null;
        while (rule != null) {
            if (rule.getPrecedence() < precedence || rule.getPrecedence() == precedence && rule.getPriority() <= priority) {
                newRule.setNext(rule);
                if (prev == null) {
                    this.ruleDict[key] = newRule;
                    break;
                }
                prev.setNext(newRule);
                break;
            }
            prev = rule;
            rule = rule.getNext();
        }
        if (rule == null) {
            prev.setNext(newRule);
            newRule.setNext(null);
        }
    }

    public int getList(int fingerprint, int kind) {
        if (kind == 1) {
            if (fingerprint == -1) {
                return 0;
            }
            return 13 + fingerprint % 101;
        }
        return kind;
    }

    public Rule getRule(NodeInfo node, XPathContext context) throws XPathException {
        int fingerprint = node.getFingerprint();
        int type = node.getNodeKind();
        int key = this.getList(fingerprint, type);
        int policy = context.getController().getRecoveryPolicy();
        context = this.perhapsMakeNewContext(context);
        Rule specificRule = null;
        Rule generalRule = null;
        int specificPrecedence = -1;
        double specificPriority = Double.NEGATIVE_INFINITY;
        if (key != 0) {
            for (Rule r = this.ruleDict[key]; !(r == null || specificRule != null && (r.getPrecedence() < specificPrecedence || r.getPrecedence() == specificPrecedence && r.getPriority() < specificPriority)); r = r.getNext()) {
                if (!r.getPattern().matches(node, context)) continue;
                if (specificRule != null) {
                    if (r.getPrecedence() != specificPrecedence || r.getPriority() != specificPriority) break;
                    this.reportAmbiguity(node, specificRule, r, context);
                    break;
                }
                specificRule = r;
                specificPrecedence = r.getPrecedence();
                specificPriority = r.getPriority();
                if (policy == 0) break;
            }
        }
        for (Rule r2 = this.ruleDict[0]; !(r2 == null || r2.getPrecedence() < specificPrecedence || r2.getPrecedence() == specificPrecedence && r2.getPriority() < specificPriority); r2 = r2.getNext()) {
            if (!r2.getPattern().matches(node, context)) continue;
            if (generalRule != null) {
                if (r2.getPrecedence() != generalRule.getPrecedence() || r2.getPriority() != generalRule.getPriority()) break;
                this.reportAmbiguity(node, r2, generalRule, context);
                break;
            }
            generalRule = r2;
            if (policy == 0) break;
        }
        if (specificRule != null && generalRule == null) {
            return specificRule;
        }
        if (specificRule == null && generalRule != null) {
            return generalRule;
        }
        if (specificRule != null) {
            if (specificRule.getPrecedence() == generalRule.getPrecedence() && specificRule.getPriority() == generalRule.getPriority()) {
                Rule result;
                Rule rule = result = specificRule.getSequence() > generalRule.getSequence() ? specificRule : generalRule;
                if (policy != 0) {
                    this.reportAmbiguity(node, specificRule, generalRule, context);
                }
                return result;
            }
            if (specificRule.getPrecedence() > generalRule.getPrecedence() || specificRule.getPrecedence() == generalRule.getPrecedence() && specificRule.getPriority() >= generalRule.getPriority()) {
                return specificRule;
            }
            return generalRule;
        }
        return null;
    }

    private XPathContext perhapsMakeNewContext(XPathContext context) {
        int patternLocals = context.getController().getExecutable().getLargestPatternStackFrame();
        if (patternLocals > 0) {
            context = context.newContext();
            context.setOrigin(context.getController());
            ((XPathContextMajor)context).openStackFrame(patternLocals);
        }
        return context;
    }

    public Rule getRule(NodeInfo node, int min, int max, XPathContext context) throws XPathException {
        int fp = node.getFingerprint();
        int type = node.getNodeKind();
        int key = this.getList(fp, type);
        Rule specificRule = null;
        Rule generalRule = null;
        context = this.perhapsMakeNewContext(context);
        if (key != 0) {
            for (Rule r = this.ruleDict[key]; r != null; r = r.getNext()) {
                if (r.getPrecedence() < min || r.getPrecedence() > max || !r.getPattern().matches(node, context)) continue;
                specificRule = r;
                break;
            }
        }
        for (Rule r2 = this.ruleDict[0]; r2 != null; r2 = r2.getNext()) {
            if (r2.getPrecedence() < min || r2.getPrecedence() > max || !r2.getPattern().matches(node, context)) continue;
            generalRule = r2;
            break;
        }
        if (specificRule != null && generalRule == null) {
            return specificRule;
        }
        if (specificRule == null && generalRule != null) {
            return generalRule;
        }
        if (specificRule != null) {
            if (specificRule.getPrecedence() > generalRule.getPrecedence() || specificRule.getPrecedence() == generalRule.getPrecedence() && specificRule.getPriority() >= generalRule.getPriority()) {
                return specificRule;
            }
            return generalRule;
        }
        return null;
    }

    public Rule getNextMatchRule(NodeInfo node, Rule currentRule, XPathContext context) throws XPathException {
        int fingerprint = node.getFingerprint();
        int type = node.getNodeKind();
        int key = this.getList(fingerprint, type);
        int policy = context.getController().getRecoveryPolicy();
        context = this.perhapsMakeNewContext(context);
        Rule specificRule = null;
        Rule generalRule = null;
        int specificPrecedence = -1;
        double specificPriority = Double.NEGATIVE_INFINITY;
        if (key != 0) {
            for (Rule r = this.ruleDict[key]; r != null; r = r.getNext()) {
                if (r == currentRule || r.getPrecedence() > currentRule.getPrecedence() || r.getPrecedence() == currentRule.getPrecedence() && (r.getPriority() > currentRule.getPriority() || r.getPriority() == currentRule.getPriority() && r.getSequence() >= currentRule.getSequence())) continue;
                if (specificRule != null && (r.getPrecedence() < specificPrecedence || r.getPrecedence() == specificPrecedence && r.getPriority() < specificPriority)) break;
                if (!r.getPattern().matches(node, context)) continue;
                if (specificRule != null) {
                    if (r.getPrecedence() != specificPrecedence || r.getPriority() != specificPriority) break;
                    this.reportAmbiguity(node, specificRule, r, context);
                    break;
                }
                specificRule = r;
                specificPrecedence = r.getPrecedence();
                specificPriority = r.getPriority();
                if (policy == 0) break;
            }
        }
        for (Rule r2 = this.ruleDict[0]; r2 != null; r2 = r2.getNext()) {
            if (r2 == currentRule || r2.getPrecedence() > currentRule.getPrecedence() || r2.getPrecedence() == currentRule.getPrecedence() && (r2.getPriority() > currentRule.getPriority() || r2.getPriority() == currentRule.getPriority() && r2.getSequence() >= currentRule.getSequence())) continue;
            if (r2.getPrecedence() < specificPrecedence || r2.getPrecedence() == specificPrecedence && r2.getPriority() < specificPriority) break;
            if (!r2.getPattern().matches(node, context)) continue;
            if (generalRule != null) {
                if (r2.getPrecedence() != generalRule.getPrecedence() || r2.getPriority() != generalRule.getPriority()) break;
                this.reportAmbiguity(node, r2, generalRule, context);
                break;
            }
            generalRule = r2;
            if (policy == 0) break;
        }
        if (specificRule != null && generalRule == null) {
            return specificRule;
        }
        if (specificRule == null && generalRule != null) {
            return generalRule;
        }
        if (specificRule != null && generalRule != null) {
            if (specificRule.getPrecedence() == generalRule.getPrecedence() && specificRule.getPriority() == generalRule.getPriority()) {
                Rule result;
                Rule rule = result = specificRule.getSequence() > generalRule.getSequence() ? specificRule : generalRule;
                if (policy != 0) {
                    this.reportAmbiguity(node, specificRule, generalRule, context);
                }
                return result;
            }
            if (specificRule.getPrecedence() > generalRule.getPrecedence() || specificRule.getPrecedence() == generalRule.getPrecedence() && specificRule.getPriority() >= generalRule.getPriority()) {
                return specificRule;
            }
            return generalRule;
        }
        return null;
    }

    private void reportAmbiguity(NodeInfo node, Rule r1, Rule r2, XPathContext c) throws XPathException {
        String path;
        if (r1.getAction() == r2.getAction()) {
            return;
        }
        String errorCode = "XTRE0540";
        if (this.isStripper) {
            if (r1.getAction().equals(r2.getAction())) {
                return;
            }
            errorCode = "XTRE0270";
            path = "xsl:strip-space";
        } else {
            path = Navigator.getPath(node);
        }
        Pattern pat1 = r1.getPattern();
        Pattern pat2 = r2.getPattern();
        XPathException err = new XPathException("Ambiguous rule match for " + path + '\n' + "Matches both \"" + Mode.showPattern(pat1) + "\" on line " + pat1.getLineNumber() + " of " + pat1.getSystemId() + "\nand \"" + Mode.showPattern(pat2) + "\" on line " + pat2.getLineNumber() + " of " + pat2.getSystemId());
        err.setErrorCode(errorCode);
        err.setLocator(c.getOrigin().getInstructionInfo());
        c.getController().recoverableError(err);
    }

    private static String showPattern(Pattern p) {
        return Whitespace.collapseWhitespace(p.toString()).toString();
    }

    public void explainTemplateRules(ExpressionPresenter presenter) {
        for (int i = 0; i < this.ruleDict.length; ++i) {
            for (Rule r = this.ruleDict[i]; r != null; r = r.getNext()) {
                int e;
                Template t = (Template)r.getAction();
                int s = presenter.startElement("templateRule");
                presenter.emitAttribute("match", r.getPattern().toString());
                presenter.emitAttribute("precedence", r.getPrecedence() + "");
                presenter.emitAttribute("priority", r.getPriority() + "");
                presenter.emitAttribute("line", t.getLineNumber() + "");
                presenter.emitAttribute("module", t.getSystemId());
                if (t.getBody() != null) {
                    t.getBody().explain(presenter);
                }
                if (s == (e = presenter.endElement())) continue;
                throw new IllegalStateException("tree unbalanced");
            }
        }
    }
}

