/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyChangeEvent;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XFastPropertySet;
import com.sun.star.beans.XMultiPropertySet;
import com.sun.star.beans.XPropertiesChangeListener;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.lib.uno.helper.InterfaceContainer;
import com.sun.star.lib.uno.helper.MultiTypeInterfaceContainer;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Enum;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class PropertySet
extends ComponentBase
implements XPropertySet,
XFastPropertySet,
XMultiPropertySet {
    private HashMap _nameToPropertyMap;
    private HashMap _handleToPropertyMap;
    private HashMap _propertyToIdMap;
    private Property[] arProperties;
    private int lastHandle = 1;
    protected XPropertySetInfo propertySetInfo;
    protected MultiTypeInterfaceContainer aBoundLC = new MultiTypeInterfaceContainer();
    protected MultiTypeInterfaceContainer aVetoableLC = new MultiTypeInterfaceContainer();

    public PropertySet() {
        this.initMappings();
    }

    protected void registerProperty(Property property, Object object) {
        this.putProperty(property);
        this.assignPropertyId(property, object);
    }

    protected void registerProperty(String string, int n, Type type, short s, Object object) {
        Property property = new Property(string, n, type, s);
        this.registerProperty(property, object);
    }

    protected void registerProperty(String string, Type type, short s, Object object) {
        Property property = new Property(string, this.lastHandle++, type, s);
        this.registerProperty(property, object);
    }

    protected void registerProperty(String string, String string2, short s) {
        Field field = null;
        try {
            field = this.getClass().getDeclaredField(string2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new com.sun.star.uno.RuntimeException("there is no member variable: " + string2);
        }
        Class<?> clazz = field.getType();
        Type type = new Type(clazz);
        if (type.getTypeClass() == TypeClass.UNKNOWN) {
            throw new com.sun.star.uno.RuntimeException("the member has an unknown type: " + string2);
        }
        Property property = new Property(string, this.lastHandle++, type, s);
        this.registerProperty(property, string2);
    }

    protected void registerProperty(String string, short s) {
        this.registerProperty(string, string, s);
    }

    protected Property getProperty(String string) {
        return (Property)this._nameToPropertyMap.get(string);
    }

    protected Property getPropertyByHandle(int n) {
        return (Property)this._handleToPropertyMap.get(new Integer(n));
    }

    protected Property[] getProperties() {
        if (this.arProperties == null) {
            Collection collection = this._nameToPropertyMap.values();
            this.arProperties = collection.toArray(new Property[this._nameToPropertyMap.size()]);
        }
        return this.arProperties;
    }

    protected void putProperty(Property property) {
        this._nameToPropertyMap.put(property.Name, property);
        if (property.Handle != -1) {
            this._handleToPropertyMap.put(new Integer(property.Handle), property);
        }
    }

    protected void assignPropertyId(Property property, Object object) {
        if (object instanceof String && !((String)object).equals("")) {
            this._propertyToIdMap.put(property, object);
        }
    }

    protected Object getPropertyId(Property property) {
        return this._propertyToIdMap.get(property);
    }

    protected void initMappings() {
        this._nameToPropertyMap = new HashMap();
        this._handleToPropertyMap = new HashMap();
        this._propertyToIdMap = new HashMap();
    }

    protected void postDisposing() {
        EventObject eventObject = new EventObject((Object)this);
        this.aBoundLC.disposeAndClear(eventObject);
        this.aVetoableLC.disposeAndClear(eventObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addPropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        if (this.bInDispose || this.bDisposed) return;
        if (string.length() > 0) {
            Property property = this.getProperty(string);
            if (property == null) {
                throw new UnknownPropertyException("Property " + string + " is unknown");
            }
            if ((property.Attributes & 2) <= 0) return;
            this.aBoundLC.addInterface(string, xPropertyChangeListener);
            return;
        } else {
            this.listenerContainer.addInterface(XPropertyChangeListener.class, xPropertyChangeListener);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        if (this.bInDispose || this.bDisposed) return;
        if (string.length() > 0) {
            Property property = this.getProperty(string);
            if (property == null) {
                throw new UnknownPropertyException("Property " + string + " is unknown");
            }
            if ((property.Attributes & 4) <= 0) return;
            this.aVetoableLC.addInterface(string, xVetoableChangeListener);
            return;
        } else {
            this.listenerContainer.addInterface(XVetoableChangeListener.class, xVetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XPropertySetInfo getPropertySetInfo() {
        if (this.propertySetInfo == null) {
            PropertySet propertySet = this;
            synchronized (propertySet) {
                if (this.propertySetInfo == null) {
                    this.propertySetInfo = new PropertySetInfo();
                }
            }
        }
        return this.propertySetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPropertyValue(String string) throws UnknownPropertyException, WrappedTargetException {
        Object object = null;
        if (this.bInDispose || this.bDisposed) {
            throw new DisposedException("The component has been disposed already");
        }
        Property property = this.getProperty(string);
        if (property == null) {
            throw new UnknownPropertyException("The property " + string + " is unknown");
        }
        PropertySet propertySet = this;
        synchronized (propertySet) {
            object = this.getPropertyValue(property);
        }
        if (object == null) {
            object = property.Type.getTypeClass() == TypeClass.INTERFACE ? new Any(property.Type, null) : new Any(new Type(Void.TYPE), null);
        }
        return object;
    }

    public synchronized void removePropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        if (!this.bInDispose && !this.bDisposed) {
            if (string.length() > 0) {
                Property property = this.getProperty(string);
                if (property == null) {
                    throw new UnknownPropertyException("Property " + string + " is unknown");
                }
                this.aBoundLC.removeInterface(string, xPropertyChangeListener);
            } else {
                this.listenerContainer.removeInterface(XPropertyChangeListener.class, xPropertyChangeListener);
            }
        }
    }

    public synchronized void removeVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        if (!this.bInDispose && !this.bDisposed) {
            if (string.length() > 0) {
                Property property = this.getProperty(string);
                if (property == null) {
                    throw new UnknownPropertyException("Property " + string + " is unknown");
                }
                this.aVetoableLC.removeInterface(string, xVetoableChangeListener);
            } else {
                this.listenerContainer.removeInterface(XVetoableChangeListener.class, xVetoableChangeListener);
            }
        }
    }

    public void setPropertyValue(String string, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        Property property = this.getProperty(string);
        if (property == null) {
            throw new UnknownPropertyException("Property " + string + " is unknown");
        }
        this.setPropertyValue(property, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertyValue(Property property, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        if ((property.Attributes & 0x10) == 16) {
            throw new PropertyVetoException();
        }
        boolean bl = false;
        if (object instanceof Any) {
            bl = ((Any)object).getObject() == null;
        } else {
            boolean bl2 = bl = object == null;
        }
        if (bl && (property.Attributes & 1) == 0) {
            throw new IllegalArgumentException("The property must have a value; the MAYBEVOID attribute is not set!");
        }
        if (this.bInDispose || this.bDisposed) {
            throw new DisposedException("Component is already disposed");
        }
        boolean bl3 = false;
        bl3 = object instanceof Any ? this.checkType(((Any)object).getObject()) : this.checkType(object);
        if (!bl3) {
            throw new IllegalArgumentException("No valid UNO type");
        }
        boolean bl4 = false;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[1];
        PropertySet propertySet = this;
        synchronized (propertySet) {
            bl4 = this.convertPropertyValue(property, objectArray, objectArray2, object);
        }
        if (bl4) {
            this.fire(new Property[]{property}, objectArray, objectArray2, true);
            propertySet = this;
            synchronized (propertySet) {
                this.setPropertyValueNoBroadcast(property, objectArray[0]);
            }
            this.fire(new Property[]{property}, objectArray, objectArray2, false);
        }
    }

    protected boolean convertPropertyValue(Property property, Object[] objectArray, Object[] objectArray2, Object object) throws IllegalArgumentException, WrappedTargetException, UnknownPropertyException {
        boolean bl;
        block15: {
            bl = true;
            try {
                String string = (String)this.getPropertyId(property);
                if (string != null) {
                    Field field = this.getClass().getDeclaredField(string);
                    if (field != null) {
                        objectArray2[0] = field.get(this);
                        Class<?> clazz = field.getType();
                        boolean bl2 = false;
                        boolean bl3 = object instanceof Any;
                        if (bl3) {
                            bl2 = ((Any)object).getObject() == null;
                        } else {
                            boolean bl4 = bl2 = object == null;
                        }
                        if (bl2 && clazz.isPrimitive()) {
                            throw new IllegalArgumentException("The implementation does not support the MAYBEVOID attribute for this property");
                        }
                        Object object2 = null;
                        if (clazz.equals(Any.class)) {
                            if (bl3) {
                                object2 = object;
                            } else if (object instanceof XInterface) {
                                XInterface xInterface = (XInterface)UnoRuntime.queryInterface(XInterface.class, (Object)object);
                                if (xInterface != null) {
                                    object2 = new Any(new Type(XInterface.class), (Object)xInterface);
                                }
                            } else {
                                object2 = object == null ? (objectArray2[0] == null ? new Any(new Type(), null) : new Any(((Any)objectArray2[0]).getType(), null)) : new Any(new Type(object.getClass()), object);
                            }
                        } else {
                            object2 = this.convert(clazz, object);
                        }
                        objectArray[0] = object2;
                    }
                    break block15;
                }
                throw new UnknownPropertyException("Property " + property.Name + " is unknown");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new WrappedTargetException("Field does not exist", (Object)this, (Object)noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WrappedTargetException("", (Object)this, (Object)illegalAccessException);
            }
        }
        return bl;
    }

    private boolean checkType(Object object) {
        return object == null || object instanceof Boolean || object instanceof Character || object instanceof Number || object instanceof String || object instanceof XInterface || object instanceof Type || object instanceof Enum || object.getClass().isArray();
    }

    private Object convert(Class clazz, Object object) throws IllegalArgumentException {
        Object object2 = null;
        if (object == null || object instanceof Any && ((Any)object).getObject() == null) {
            object2 = null;
        } else if (clazz.equals(Object.class)) {
            if (object instanceof Any) {
                object = ((Any)object).getObject();
            }
            object2 = object;
        } else if (clazz.equals(Boolean.TYPE)) {
            object2 = new Boolean(AnyConverter.toBoolean((Object)object));
        } else if (clazz.equals(Character.TYPE)) {
            object2 = new Character(AnyConverter.toChar((Object)object));
        } else if (clazz.equals(Byte.TYPE)) {
            object2 = new Byte(AnyConverter.toByte((Object)object));
        } else if (clazz.equals(Short.TYPE)) {
            object2 = new Short(AnyConverter.toShort((Object)object));
        } else if (clazz.equals(Integer.TYPE)) {
            object2 = new Integer(AnyConverter.toInt((Object)object));
        } else if (clazz.equals(Long.TYPE)) {
            object2 = new Long(AnyConverter.toLong((Object)object));
        } else if (clazz.equals(Float.TYPE)) {
            object2 = new Float(AnyConverter.toFloat((Object)object));
        } else if (clazz.equals(Double.TYPE)) {
            object2 = new Double(AnyConverter.toDouble((Object)object));
        } else if (clazz.equals(String.class)) {
            object2 = AnyConverter.toString((Object)object);
        } else if (clazz.isArray()) {
            object2 = AnyConverter.toArray((Object)object);
        } else if (clazz.equals(Type.class)) {
            object2 = AnyConverter.toType((Object)object);
        } else if (clazz.equals(Boolean.class)) {
            object2 = new Boolean(AnyConverter.toBoolean((Object)object));
        } else if (clazz.equals(Character.class)) {
            object2 = new Character(AnyConverter.toChar((Object)object));
        } else if (clazz.equals(Byte.class)) {
            object2 = new Byte(AnyConverter.toByte((Object)object));
        } else if (clazz.equals(Short.class)) {
            object2 = new Short(AnyConverter.toShort((Object)object));
        } else if (clazz.equals(Integer.class)) {
            object2 = new Integer(AnyConverter.toInt((Object)object));
        } else if (clazz.equals(Long.class)) {
            object2 = new Long(AnyConverter.toLong((Object)object));
        } else if (clazz.equals(Float.class)) {
            object2 = new Float(AnyConverter.toFloat((Object)object));
        } else if (clazz.equals(Double.class)) {
            object2 = new Double(AnyConverter.toDouble((Object)object));
        } else if (XInterface.class.isAssignableFrom(clazz)) {
            object2 = AnyConverter.toObject((Type)new Type(clazz), (Object)object);
        } else if (Enum.class.isAssignableFrom(clazz)) {
            object2 = AnyConverter.toObject((Type)new Type(clazz), (Object)object);
        } else {
            throw new IllegalArgumentException("Could not convert the argument");
        }
        return object2;
    }

    protected void setPropertyValueNoBroadcast(Property property, Object object) throws WrappedTargetException {
        try {
            Field field;
            String string = (String)this.getPropertyId(property);
            if (string != null && (field = this.getClass().getDeclaredField(string)) != null) {
                field.set(this, object);
            }
        }
        catch (Exception exception) {
            throw new WrappedTargetException("PropertySet.setPropertyValueNoBroadcast", (Object)this, (Object)exception);
        }
    }

    protected Object getPropertyValue(Property property) {
        Object object = null;
        try {
            Field field;
            String string = (String)this.getPropertyId(property);
            if (string != null && (field = this.getClass().getDeclaredField(string)) != null) {
                object = field.get(this);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return object;
    }

    protected void fire(Property[] propertyArray, Object[] objectArray, Object[] objectArray2, boolean bl) throws PropertyVetoException {
        int n = propertyArray.length;
        if (n > 0) {
            Object object;
            Iterator iterator;
            InterfaceContainer interfaceContainer;
            int n2;
            PropertyChangeEvent[] propertyChangeEventArray = new PropertyChangeEvent[n];
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                if ((!bl || (propertyArray[n2].Attributes & 4) <= 0) && (bl || (propertyArray[n2].Attributes & 2) <= 0)) continue;
                propertyChangeEventArray[n2] = new PropertyChangeEvent((Object)this, propertyArray[n2].Name, false, propertyArray[n2].Handle, objectArray2[n2], objectArray[n2]);
                ++n3;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                interfaceContainer = null;
                interfaceContainer = bl ? this.aVetoableLC.getContainer(propertyChangeEventArray[n2].PropertyName) : this.aBoundLC.getContainer(propertyChangeEventArray[n2].PropertyName);
                if (interfaceContainer != null) {
                    iterator = interfaceContainer.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (bl) {
                            ((XVetoableChangeListener)object).vetoableChange(propertyChangeEventArray[n2]);
                            continue;
                        }
                        ((XPropertyChangeListener)object).propertyChange(propertyChangeEventArray[n2]);
                    }
                }
                if ((interfaceContainer = bl ? this.listenerContainer.getContainer(XVetoableChangeListener.class) : this.listenerContainer.getContainer(XPropertyChangeListener.class)) == null) continue;
                iterator = interfaceContainer.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (bl) {
                        ((XVetoableChangeListener)object).vetoableChange(propertyChangeEventArray[n2]);
                        continue;
                    }
                    ((XPropertyChangeListener)object).propertyChange(propertyChangeEventArray[n2]);
                }
            }
            if (!bl && n3 > 0) {
                PropertyChangeEvent[] propertyChangeEventArray2 = new PropertyChangeEvent[n3];
                System.arraycopy(propertyChangeEventArray, 0, propertyChangeEventArray2, 0, n3);
                interfaceContainer = this.listenerContainer.getContainer(XPropertiesChangeListener.class);
                if (interfaceContainer != null) {
                    iterator = interfaceContainer.iterator();
                    while (iterator.hasNext()) {
                        object = (XPropertiesChangeListener)iterator.next();
                        object.propertiesChange(propertyChangeEventArray);
                    }
                }
            }
        }
    }

    public void setFastPropertyValue(int n, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        Property property = this.getPropertyByHandle(n);
        if (property == null) {
            throw new UnknownPropertyException(" The property with handle : " + n + " is unknown");
        }
        this.setPropertyValue(property, object);
    }

    public Object getFastPropertyValue(int n) throws UnknownPropertyException, WrappedTargetException {
        Property property = this.getPropertyByHandle(n);
        if (property == null) {
            throw new UnknownPropertyException("The property with handle : " + n + " is unknown");
        }
        return this.getPropertyValue(property);
    }

    public void addPropertiesChangeListener(String[] stringArray, XPropertiesChangeListener xPropertiesChangeListener) {
        this.listenerContainer.addInterface(XPropertiesChangeListener.class, xPropertiesChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertiesChangeEvent(String[] stringArray, XPropertiesChangeListener xPropertiesChangeListener) {
        PropertyChangeEvent[] propertyChangeEventArray = new PropertyChangeEvent[stringArray.length];
        int n = 0;
        PropertyChangeEvent[] propertyChangeEventArray2 = this;
        synchronized (this) {
            for (int i = 0; i < stringArray.length; ++i) {
                Property property = this.getProperty(stringArray[i]);
                if (property == null) continue;
                Object object = null;
                try {
                    object = this.getPropertyValue(property);
                }
                catch (Exception exception) {
                    continue;
                }
                propertyChangeEventArray[n] = new PropertyChangeEvent((Object)this, property.Name, false, property.Handle, object, object);
                ++n;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (n > 0) {
                if (propertyChangeEventArray.length != n) {
                    propertyChangeEventArray2 = new PropertyChangeEvent[n];
                    System.arraycopy(propertyChangeEventArray, 0, propertyChangeEventArray2, 0, n);
                    propertyChangeEventArray = propertyChangeEventArray2;
                }
                xPropertiesChangeListener.propertiesChange(propertyChangeEventArray);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getPropertyValues(String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length];
        PropertySet propertySet = this;
        synchronized (propertySet) {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = null;
                try {
                    object = this.getPropertyValue(stringArray[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                objectArray[i] = object;
            }
        }
        return objectArray;
    }

    public void removePropertiesChangeListener(XPropertiesChangeListener xPropertiesChangeListener) {
        this.listenerContainer.removeInterface(XPropertiesChangeListener.class, xPropertiesChangeListener);
    }

    public void setPropertyValues(String[] stringArray, Object[] objectArray) throws PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.setPropertyValue(stringArray[i], objectArray[i]);
                continue;
            }
            catch (UnknownPropertyException unknownPropertyException) {
                // empty catch block
            }
        }
    }

    private class PropertySetInfo
    implements XPropertySetInfo {
        private PropertySetInfo() {
        }

        public Property[] getProperties() {
            return PropertySet.this.getProperties();
        }

        public Property getPropertyByName(String string) throws UnknownPropertyException {
            return PropertySet.this.getProperty(string);
        }

        public boolean hasPropertyByName(String string) {
            return PropertySet.this.getProperty(string) != null;
        }
    }
}

