/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import java.io.InputStream;

public class InputStreamToXInputStreamAdapter
implements XInputStream {
    private InputStream iIn;

    public InputStreamToXInputStreamAdapter(InputStream inputStream) {
        this.iIn = inputStream;
    }

    public int available() throws IOException {
        int n;
        try {
            n = this.iIn.available();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException.toString());
        }
        return n;
    }

    public void closeInput() throws IOException {
        try {
            this.iIn.close();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException.toString());
        }
    }

    public int readBytes(byte[][] byArray, int n) throws IOException {
        boolean bl = false;
        try {
            long l = 0L;
            int n2 = 0;
            if (byArray[0] == null || byArray[0].length < n) {
                byArray[0] = new byte[n];
            }
            while (n > 0 && (l = (long)this.iIn.read(byArray[0], n2, n)) > 0L) {
                n2 += (int)l;
                n -= (int)l;
            }
            if (n2 < byArray[0].length) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray[0], 0, byArray2, 0, n2);
                byArray[0] = byArray2;
            }
            return n2;
        }
        catch (java.io.IOException iOException) {
            throw new IOException("reader error: " + iOException.toString());
        }
    }

    public int readSomeBytes(byte[][] byArray, int n) throws IOException {
        boolean bl = false;
        try {
            long l = 0L;
            if (byArray[0] == null || byArray[0].length < n) {
                byArray[0] = new byte[n];
            }
            if ((l = n > this.iIn.available() ? (long)this.iIn.read(byArray[0], 0, this.iIn.available()) : (long)this.iIn.read(byArray[0], 0, n)) < (long)byArray[0].length) {
                int n2 = l > 0L ? (int)l : 0;
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray[0], 0, byArray2, 0, n2);
                byArray[0] = byArray2;
            }
            if (l <= 0L) {
                return 0;
            }
            return (int)l;
        }
        catch (java.io.IOException iOException) {
            throw new IOException("reader error: " + iOException.toString());
        }
    }

    public void skipBytes(int n) throws IOException {
        int n2 = n;
        try {
            int n3 = this.iIn.available();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException.toString());
        }
        do {
            int n4 = n2 >= Integer.MAX_VALUE ? Integer.MAX_VALUE : n2;
            n2 -= n4;
            try {
                this.iIn.skip(n4);
            }
            catch (java.io.IOException iOException) {
                throw new IOException(iOException.toString());
            }
        } while (n2 > 0);
    }
}

