/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.NativeFrame;

public class Dialog
extends java.awt.Dialog
implements Accessible,
NativeFrame {
    protected XAccessibleComponent unoAccessibleComponent;
    boolean opened = false;
    boolean visible = false;
    boolean active = false;
    EventQueue eventQueue = null;
    Component initialComponent = null;
    AccessibleContext accessibleContext = null;

    protected Dialog(Frame frame, XAccessibleComponent xAccessibleComponent) {
        super(frame);
        this.initialize(xAccessibleComponent);
    }

    protected Dialog(Frame frame, String string, XAccessibleComponent xAccessibleComponent) {
        super(frame, string);
        this.initialize(xAccessibleComponent);
    }

    protected Dialog(Frame frame, String string, boolean bl, XAccessibleComponent xAccessibleComponent) {
        super(frame, string, bl);
        this.initialize(xAccessibleComponent);
    }

    private void initialize(XAccessibleComponent xAccessibleComponent) {
        this.unoAccessibleComponent = xAccessibleComponent;
        this.eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        XAccessibleEventBroadcaster xAccessibleEventBroadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)xAccessibleComponent);
        if (xAccessibleEventBroadcaster != null) {
            xAccessibleEventBroadcaster.addEventListener((XAccessibleEventListener)new AccessibleDialogListener());
        }
    }

    public Component getInitialComponent() {
        return this.initialComponent;
    }

    public void setInitialComponent(Component component) {
        this.initialComponent = component;
    }

    public Integer getHWND() {
        return null;
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container container = this.getParent();
            return container == null || container.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDisplayable() {
        return true;
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            if (bl) {
                if (!this.opened) {
                    this.postWindowEvent(200);
                    this.opened = true;
                }
                this.postComponentEvent(102);
            } else {
                this.postComponentEvent(103);
            }
        }
    }

    public void dispose() {
        this.setVisible(false);
        this.postWindowEvent(202);
    }

    protected void postWindowEvent(int n) {
        this.eventQueue.postEvent(new WindowEvent(this, n));
    }

    protected void postComponentEvent(int n) {
        this.eventQueue.postEvent(new ComponentEvent(this, n));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDialog();
            this.accessibleContext.setAccessibleName(this.getTitle());
        }
        return this.accessibleContext;
    }

    protected class AccessibleDialog
    extends Dialog.AccessibleAWTDialog {
        protected ComponentListener accessibleComponentHandler;
        protected WindowListener accessibleWindowHandler;
        protected ContainerListener accessibleContainerHandler;
        protected int propertyChangeListenerCount;

        protected AccessibleDialog() {
            super(Dialog.this);
            this.accessibleComponentHandler = null;
            this.accessibleWindowHandler = null;
            this.accessibleContainerHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleWindowHandler = new AccessibleWindowHandler();
                Dialog.this.addWindowListener(this.accessibleWindowHandler);
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                Dialog.this.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Dialog.this.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyChangeListenerCount == 0) {
                Dialog.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Dialog.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
                Dialog.this.removeWindowListener(this.accessibleWindowHandler);
                this.accessibleWindowHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public Color getBackground() {
            try {
                return new Color(Dialog.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            try {
                return new Color(Dialog.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public boolean isEnabled() {
            return Dialog.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return Dialog.this.isVisible();
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return Dialog.this.isShowing();
        }

        public boolean contains(java.awt.Point point) {
            try {
                return Dialog.this.unoAccessibleComponent.containsPoint(new Point(point.x, point.y));
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point point = Dialog.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point point = Dialog.this.unoAccessibleComponent.getLocation();
                return new java.awt.Point(point.X, point.Y);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setLocation(java.awt.Point point) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle rectangle = Dialog.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle rectangle) {
        }

        public Dimension getSize() {
            try {
                Size size = Dialog.this.unoAccessibleComponent.getSize();
                return new Dimension(size.Width, size.Height);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(java.awt.Point point) {
            try {
                Component component = AccessibleObjectFactory.getAccessibleComponent(Dialog.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(point.x, point.y)));
                return (Accessible)((Object)component);
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public boolean isFocusTraversable() {
            return Dialog.this.isFocusable();
        }

        public void requestFocus() {
            Dialog.this.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleDialog.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleDialog.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleWindowHandler
        implements WindowListener {
            protected AccessibleWindowHandler() {
            }

            public void windowActivated(WindowEvent windowEvent) {
                AccessibleDialog.this.firePropertyChange("AccessibleState", null, AccessibleState.ACTIVE);
            }

            public void windowClosed(WindowEvent windowEvent) {
            }

            public void windowClosing(WindowEvent windowEvent) {
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                AccessibleDialog.this.firePropertyChange("AccessibleState", AccessibleState.ACTIVE, null);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                AccessibleDialog.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent componentEvent) {
                AccessibleDialog.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }
        }
    }

    protected class AccessibleDialogListener
    implements XAccessibleEventListener {
        protected AccessibleDialogListener() {
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 1: {
                    Dialog.this.active = bl;
                    if (bl) {
                        AccessibleObjectFactory.postWindowActivated(Dialog.this);
                        break;
                    }
                    AccessibleObjectFactory.postWindowLostFocus(Dialog.this);
                    break;
                }
                case 13: {
                    Dialog.this.postWindowEvent(bl ? 203 : 204);
                    break;
                }
                case 30: {
                    Dialog.this.setVisible(bl);
                    break;
                }
            }
        }

        protected void handleNameChangedEvent(Object object) {
            try {
                String string = AnyConverter.toString((Object)object);
                Dialog.this.setTitle(string);
                AccessibleContext accessibleContext = Dialog.this.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object object) {
            try {
                AccessibleContext accessibleContext = Dialog.this.accessibleContext;
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)object));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object object, Object object2) {
            try {
                if (AnyConverter.isShort((Object)object)) {
                    this.setComponentState(AnyConverter.toShort((Object)object), false);
                }
                if (AnyConverter.isShort((Object)object2)) {
                    this.setComponentState(AnyConverter.toShort((Object)object2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleVisibleDataEvent() {
            AccessibleContext accessibleContext = Dialog.this.accessibleContext;
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleVisibleData", null, null);
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 1: {
                    this.handleNameChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 2: {
                    this.handleDescriptionChangedEvent(accessibleEventObject.NewValue);
                    break;
                }
                case 4: {
                    this.handleStateChangedEvent(accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)accessibleEventObject.OldValue)) {
                        AccessibleObjectFactory.removeChild(Dialog.this, accessibleEventObject.OldValue);
                        break;
                    }
                    if (!AnyConverter.isObject((Object)accessibleEventObject.NewValue)) break;
                    AccessibleObjectFactory.addChild((Container)Dialog.this, accessibleEventObject.NewValue);
                    break;
                }
                case 6: 
                case 10: {
                    this.handleVisibleDataEvent();
                    break;
                }
            }
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

