/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.TextSegment;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleMultiLineText;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;
import org.openoffice.accessibility.awb.view.ViewGridLayout;
import org.openoffice.accessibility.awb.view.text.CaretSpinnerModel;
import org.openoffice.accessibility.awb.view.text.TextDialogFactory;

public class TextView
extends ObjectView
implements ActionListener {
    private static final int BEFORE = -1;
    private static final int AT = 0;
    private static final int BEHIND = 1;
    private XAccessibleText mxText;
    private JLabel maTextLabel;
    private JLabel maCharacterArrayLabel;
    private JLabel maCharacterCountLabel;
    private JLabel maSelectionLabel;
    private JLabel maBoundsLabel;
    private JLabel maCaretLineNoLabel;
    private JLabel maCaretLineTextLabel;
    private JLabel maLineNoFromCaretPosLabel;
    private JLabel maLineTextFromCaretPosLabel;
    private JSpinner maCaretPositionSpinner;
    private JTree maTree;
    private CaretSpinnerModel maCaretSpinnerModel;
    private static String[] aAttributeList = new String[]{"CharBackColor", "CharColor", "CharEscapement", "CharHeight", "CharPosture", "CharStrikeout", "CharUnderline", "CharWeight", "ParaAdjust", "ParaBottomMargin", "ParaFirstLineIndent", "ParaLeftMargin", "ParaLineSpacing", "ParaRightMargin", "ParaTabStops"};

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        XAccessibleText xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)xAccessibleContext);
        if (xAccessibleText != null) {
            return new TextView(objectViewContainer);
        }
        return null;
    }

    public TextView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        ViewGridLayout viewGridLayout = new ViewGridLayout(this);
        this.maTextLabel = viewGridLayout.AddLabeledString("Text: ");
        this.maCharacterArrayLabel = viewGridLayout.AddLabeledEntry("Characters: ");
        this.maCharacterCountLabel = viewGridLayout.AddLabeledEntry("Character Count: ");
        this.maSelectionLabel = viewGridLayout.AddLabeledEntry("Selection: ");
        this.maBoundsLabel = viewGridLayout.AddLabeledEntry("Bounds Test: ");
        this.maCaretPositionSpinner = (JSpinner)viewGridLayout.AddLabeledComponent("Caret position:", new JSpinner());
        Dimension dimension = this.maCaretPositionSpinner.getSize();
        this.maCaretPositionSpinner.setPreferredSize(new Dimension(100, 20));
        this.maCaretLineNoLabel = viewGridLayout.AddLabeledEntry("Line number at caret: ");
        this.maCaretLineTextLabel = viewGridLayout.AddLabeledEntry("Text of line at caret: ");
        this.maLineNoFromCaretPosLabel = viewGridLayout.AddLabeledEntry("Line number at index of caret: ");
        this.maLineTextFromCaretPosLabel = viewGridLayout.AddLabeledEntry("Text of line at index of caret: ");
        JPanel jPanel = new JPanel();
        viewGridLayout.AddComponent(jPanel);
        JButton jButton = new JButton("select...");
        jButton.setFont(viewGridLayout.GetFont());
        jButton.addActionListener(this);
        jPanel.add(jButton);
        jButton = new JButton("copy...");
        jButton.setFont(viewGridLayout.GetFont());
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.maTree = new JTree();
        viewGridLayout.AddComponent(new JScrollPane(this.maTree, 20, 30));
    }

    public void SetObject(XAccessibleContext xAccessibleContext) {
        this.mxText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)xAccessibleContext);
        this.maCaretSpinnerModel = new CaretSpinnerModel(this.mxText);
        this.maCaretPositionSpinner.setModel(this.maCaretSpinnerModel);
        super.SetObject(xAccessibleContext);
    }

    public synchronized void Destroy() {
        this.mxText = null;
        super.Destroy();
    }

    public synchronized void Update() {
        this.maCaretPositionSpinner.setEnabled(this.mxText != null);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Text Segments");
        if (this.mxText == null) {
            this.maTextLabel.setText("<null object>");
            this.maCharacterArrayLabel.setText("<null object>");
            this.maCharacterCountLabel.setText("<null object>");
            this.maSelectionLabel.setText("<null object>");
            this.maBoundsLabel.setText("<null object>");
            this.maCaretLineNoLabel.setText("<null object>");
            this.maCaretLineTextLabel.setText("<null object>");
            this.maLineNoFromCaretPosLabel.setText("<null object>");
            this.maLineTextFromCaretPosLabel.setText("<null object>");
        } else {
            this.maTextLabel.setText(this.mxText.getText());
            this.maCharacterArrayLabel.setText(this.GetCharacterArray());
            this.maCharacterCountLabel.setText(Integer.toString(this.mxText.getCharacterCount()));
            this.maSelectionLabel.setText("[" + this.mxText.getSelectionStart() + "," + this.mxText.getSelectionEnd() + "] \"" + this.mxText.getSelectedText() + "\"");
            this.maBoundsLabel.setText(this.GetTextBoundsString());
            this.maCaretPositionSpinner.setValue(new Integer(this.mxText.getCaretPosition()));
            XAccessibleMultiLineText xAccessibleMultiLineText = (XAccessibleMultiLineText)UnoRuntime.queryInterface(XAccessibleMultiLineText.class, (Object)this.mxText);
            if (null != xAccessibleMultiLineText) {
                try {
                    this.maCaretLineNoLabel.setText(Integer.toString(xAccessibleMultiLineText.getNumberOfLineWithCaret()));
                    TextSegment textSegment = xAccessibleMultiLineText.getTextAtLineWithCaret();
                    this.maCaretLineTextLabel.setText("[" + textSegment.SegmentStart + "," + textSegment.SegmentEnd + "] \"" + textSegment.SegmentText + "\"");
                    this.maLineNoFromCaretPosLabel.setText(Integer.toString(xAccessibleMultiLineText.getLineNumberAtIndex(this.mxText.getCaretPosition())));
                    textSegment = xAccessibleMultiLineText.getTextAtLineNumber(xAccessibleMultiLineText.getLineNumberAtIndex(this.mxText.getCaretPosition()));
                    this.maLineTextFromCaretPosLabel.setText("[" + textSegment.SegmentStart + "," + textSegment.SegmentEnd + "] \"" + textSegment.SegmentText + "\"");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            defaultMutableTreeNode.add(this.CreateNode("Character", (short)1));
            defaultMutableTreeNode.add(this.CreateNode("Word", (short)2));
            defaultMutableTreeNode.add(this.CreateNode("Sentence", (short)3));
            defaultMutableTreeNode.add(this.CreateNode("Paragraph", (short)4));
            defaultMutableTreeNode.add(this.CreateNode("Line", (short)5));
            defaultMutableTreeNode.add(this.CreateNode("Attribute", (short)7));
            defaultMutableTreeNode.add(this.CreateNode("Glyph", (short)6));
        }
        ((DefaultTreeModel)this.maTree.getModel()).setRoot(defaultMutableTreeNode);
    }

    public String GetTitle() {
        return "Text";
    }

    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        System.out.println(accessibleEventObject);
        switch (accessibleEventObject.EventId) {
            case 20: {
                this.maCaretSpinnerModel.Update();
                this.Update();
                break;
            }
            case 21: 
            case 22: {
                this.Update();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("select...")) {
            TextDialogFactory.CreateSelectionDialog(this.mxContext);
        } else if (string.equals("copy...")) {
            TextDialogFactory.CreateCopyDialog(this.mxContext);
        }
    }

    private String GetCharacterArray() {
        int n;
        int n2 = this.mxText.getCharacterCount();
        int n3 = 30;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (n = 0; n < n2 && n < n3; ++n) {
                stringBuffer.append(this.mxText.getCharacter(n));
                if (n >= n2 - 1) continue;
                stringBuffer.append(",");
            }
            if (n3 < n2) {
                stringBuffer.append(", ...");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            stringBuffer.append("; Index Out Of Bounds at index " + n);
        }
        return stringBuffer.toString();
    }

    private String GetTextBoundsString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = this.mxText.getCharacterCount();
            for (int i = 0; i < n; ++i) {
                Rectangle rectangle = this.mxText.getCharacterBounds(i);
                Point point = new Point();
                point.X = rectangle.X + rectangle.Width / 2 - 1;
                point.Y = rectangle.Y + rectangle.Height / 2 - 1;
                int n2 = this.mxText.getIndexAtPoint(point);
                if (n2 >= 0 && n2 < this.mxText.getCharacter(i)) {
                    stringBuffer.append(this.mxText.getCharacter(n2));
                    continue;
                }
                stringBuffer.append('#');
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private MutableTreeNode CreateNode(String string, short s) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(this.CreateSegmentNode("Before", s, -1));
        defaultMutableTreeNode.add(this.CreateSegmentNode("At", s, 0));
        defaultMutableTreeNode.add(this.CreateSegmentNode("Behind", s, 1));
        return defaultMutableTreeNode;
    }

    private MutableTreeNode CreateSegmentNode(String string, short s, int n) {
        int n2 = this.mxText.getCharacterCount();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        int n3 = 0;
        while (n3 <= n2) {
            TextSegment textSegment = this.GetTextSegment(n3, s, n);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new StringBuffer(Integer.toString(n3) + " -> " + Integer.toString(textSegment.SegmentStart) + " - " + Integer.toString(textSegment.SegmentEnd) + " : " + textSegment.SegmentText.toString()));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (s == 7) {
                this.AddAttributeNodes(defaultMutableTreeNode2, textSegment);
            }
            if (textSegment.SegmentEnd > n3) {
                n3 = textSegment.SegmentEnd;
                continue;
            }
            ++n3;
        }
        return defaultMutableTreeNode;
    }

    private TextSegment GetTextSegment(int n, short s, int n2) {
        TextSegment textSegment;
        try {
            switch (n2) {
                case -1: {
                    textSegment = this.mxText.getTextBeforeIndex(n, s);
                    break;
                }
                case 0: {
                    textSegment = this.mxText.getTextAtIndex(n, s);
                    break;
                }
                case 1: {
                    textSegment = this.mxText.getTextBehindIndex(n, s);
                    break;
                }
                default: {
                    textSegment = new TextSegment();
                    textSegment.SegmentText = new String("unknown position " + n2);
                    textSegment.SegmentStart = n;
                    textSegment.SegmentStart = n + 1;
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            textSegment = new TextSegment();
            textSegment.SegmentText = new String("Invalid index at ") + n + " : " + indexOutOfBoundsException.toString();
            textSegment.SegmentStart = n;
            textSegment.SegmentEnd = n + 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            textSegment = new TextSegment();
            textSegment.SegmentText = new String("Illegal argument at ") + n + " : " + illegalArgumentException.toString();
            textSegment.SegmentStart = n;
            textSegment.SegmentEnd = n + 1;
        }
        return textSegment;
    }

    private void AddAttributeNodes(DefaultMutableTreeNode defaultMutableTreeNode, TextSegment textSegment) {
        try {
            PropertyValue[] propertyValueArray = this.mxText.getCharacterAttributes(textSegment.SegmentStart, aAttributeList);
            for (int i = 0; i < propertyValueArray.length; ++i) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(propertyValueArray[i].Name + ": " + propertyValueArray[i].Value));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("caught IndexOutOfBoundsException while retrieveing attributes"));
        }
    }
}

