/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.uno.UnoRuntime;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;
import org.openoffice.accessibility.awb.view.ViewGridLayout;
import org.openoffice.accessibility.awb.view.text.TextDialogFactory;

public class EditableTextView
extends ObjectView
implements ActionListener {
    private XAccessibleEditableText mxEditableText;

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        XAccessibleEditableText xAccessibleEditableText = (XAccessibleEditableText)UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)xAccessibleContext);
        if (xAccessibleEditableText != null) {
            return new EditableTextView(objectViewContainer);
        }
        return null;
    }

    public EditableTextView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        JButton jButton = new JButton("cut...");
        jButton.setFont(ViewGridLayout.GetFont());
        jButton.addActionListener(this);
        this.add(jButton);
        jButton = new JButton("paste...");
        jButton.setFont(ViewGridLayout.GetFont());
        jButton.addActionListener(this);
        this.add(jButton);
        jButton = new JButton("edit...");
        jButton.setFont(ViewGridLayout.GetFont());
        jButton.addActionListener(this);
        this.add(jButton);
        jButton = new JButton("format...");
        jButton.setFont(ViewGridLayout.GetFont());
        jButton.addActionListener(this);
        this.add(jButton);
    }

    public void SetObject(XAccessibleContext xAccessibleContext) {
        this.mxEditableText = (XAccessibleEditableText)UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)xAccessibleContext);
        super.SetObject(xAccessibleContext);
    }

    public String GetTitle() {
        return "Editable Text";
    }

    public synchronized void Destroy() {
        this.mxEditableText = null;
        super.Destroy();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("cut...")) {
            TextDialogFactory.CreateCutDialog(this.mxContext);
        } else if (string.equals("past...")) {
            TextDialogFactory.CreatePasteDialog(this.mxContext);
        } else if (string.equals("edit...")) {
            TextDialogFactory.CreateEditDialog(this.mxContext);
        } else if (string.equals("format...")) {
            TextDialogFactory.CreateFormatDialog(this.mxContext);
        }
    }
}

