/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpWindow
implements ActionListener {
    private static HelpWindow maInstance = null;
    private JFrame maFrame;
    private JEditorPane maContent;
    private LinkedList maHistory;
    private int maCurrentHistoryEntry;
    private JButton maPrevButton;
    private JButton maNextButton;

    public static synchronized HelpWindow Instance() {
        if (maInstance == null) {
            maInstance = new HelpWindow();
        }
        return maInstance;
    }

    public void loadFile(String string) {
        File file = new File(string);
        try {
            this.loadURL(file.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace(System.err);
        }
    }

    public void loadURL(String string) {
        try {
            this.loadURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace(System.err);
        }
    }

    public void loadURL(URL uRL) {
        this.maHistory.addLast(uRL);
        this.selectHistoryPage(this.maHistory.size() - 1);
        this.maFrame.toFront();
    }

    private HelpWindow() {
        try {
            this.maCurrentHistoryEntry = -1;
            this.maHistory = new LinkedList();
            this.maFrame = new JFrame();
            this.maFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    maInstance = null;
                }
            });
            this.maContent = this.createContentWidget();
            this.maFrame.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.maFrame.getContentPane().add((Component)new JScrollPane(this.maContent), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.maPrevButton = new JButton("Prev");
            this.maFrame.getContentPane().add((Component)this.maPrevButton, gridBagConstraints);
            this.maPrevButton.addActionListener(this);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            this.maNextButton = new JButton("Next");
            this.maFrame.getContentPane().add((Component)this.maNextButton, gridBagConstraints);
            this.maNextButton.addActionListener(this);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            JButton jButton = new JButton("Close");
            this.maFrame.getContentPane().add((Component)jButton, gridBagConstraints);
            jButton.addActionListener(this);
            this.maFrame.setSize(600, 400);
            this.maFrame.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Prev")) {
            this.selectHistoryPage(this.maCurrentHistoryEntry - 1);
        } else if (actionEvent.getActionCommand().equals("Next")) {
            this.selectHistoryPage(this.maCurrentHistoryEntry + 1);
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.maFrame.dispose();
            maInstance = null;
        }
    }

    private JEditorPane createContentWidget() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpWindow.Instance().loadURL(hyperlinkEvent.getURL());
                }
            }
        });
        return jEditorPane;
    }

    private void selectHistoryPage(int n) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.maHistory.size() - 1) {
            n = this.maHistory.size() - 1;
        }
        if (n != this.maCurrentHistoryEntry) {
            URL uRL = (URL)this.maHistory.get(n);
            try {
                this.maContent.setPage(uRL);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            this.maCurrentHistoryEntry = n;
        }
        this.maPrevButton.setEnabled(this.maCurrentHistoryEntry > 0);
        this.maNextButton.setEnabled(this.maCurrentHistoryEntry < this.maHistory.size() - 1);
    }
}

