/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.frame.TerminationVetoException;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openoffice.accessibility.awb.HelpWindow;
import org.openoffice.accessibility.awb.canvas.Canvas;
import org.openoffice.accessibility.awb.tree.AccessibilityModel;
import org.openoffice.accessibility.awb.tree.AccessibilityTree;
import org.openoffice.accessibility.awb.tree.DynamicAccessibilityModel;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;
import org.openoffice.accessibility.awb.view.ObjectViewContainerWindow;
import org.openoffice.accessibility.misc.MessageArea;
import org.openoffice.accessibility.misc.OfficeConnection;
import org.openoffice.accessibility.misc.Options;
import org.openoffice.accessibility.misc.SimpleOffice;

public class AccessibilityWorkBench
extends JFrame
implements XTerminateListener,
ActionListener,
TreeSelectionListener {
    public static final String msVersion = "v1.9";
    public String msOptionsFileName = ".AWBrc";
    private static AccessibilityWorkBench saWorkBench = null;
    private JPanel maMainPanel;
    private JPanel maButtonBar;
    private Canvas maCanvas;
    private AccessibilityTree maTree;
    private ObjectViewContainer maObjectViewContainer;
    private JButton maConnectButton;
    private JButton maQuitButton;
    private JButton maUpdateButton;
    private JButton maExpandButton;
    private JButton maShapesButton;
    private JMenuBar maMenuBar;
    private boolean mbInitialized = false;
    private Object maCurrentObject = null;

    public static void main(String[] stringArray) {
        String string = System.getenv("USER");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h") || stringArray[i].equals("--help") || stringArray[i].equals("-?")) {
                System.out.println("usage: AccessibilityWorkBench <option>*");
                System.out.println("options:");
                System.out.println(" -p <pipe-name>    name of the pipe to use to connect to OpenOffice.org.");
                System.out.println("                   Defaults to $USER.");
                System.exit(0);
                continue;
            }
            if (!stringArray[i].equals("-p")) continue;
            string = stringArray[++i];
        }
        saWorkBench = new AccessibilityWorkBench(string);
    }

    public static AccessibilityWorkBench Instance() {
        return saWorkBench;
    }

    private AccessibilityWorkBench(String string) {
        OfficeConnection.SetPipeName(string);
        Options.Instance().Load(this.msOptionsFileName);
        this.Layout();
        MessageArea.println(System.getProperty("os.name") + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version"));
        MessageArea.println("Using pipe name " + string);
        this.maTree.addTreeSelectionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AccessibilityWorkBench.this.Quit();
            }
        });
        OfficeConnection.Instance().AddConnectionListener(this);
        this.Initialize();
    }

    public void Layout() {
        this.setSize(new Dimension(800, 600));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        DynamicAccessibilityModel dynamicAccessibilityModel = new DynamicAccessibilityModel();
        this.maTree = new AccessibilityTree(dynamicAccessibilityModel);
        this.maTree.addTreeExpansionListener(dynamicAccessibilityModel);
        this.maTree.addTreeWillExpandListener(dynamicAccessibilityModel);
        JScrollPane jScrollPane = new JScrollPane(this.maTree, 22, 32);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        this.maObjectViewContainer = new ObjectViewContainer();
        JScrollPane jScrollPane2 = new JScrollPane(this.maObjectViewContainer, 20, 30);
        jScrollPane2.setPreferredSize(new Dimension(400, 300));
        JButton jButton = new JButton("CreateNewViewWindow");
        jButton.addActionListener(this);
        jScrollPane2.setCorner("LOWER_RIGHT_CORNER", jButton);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setDividerLocation(300);
        jSplitPane.setContinuousLayout(true);
        this.maCanvas = new Canvas();
        this.maCanvas.SetTree(this.maTree);
        JScrollPane jScrollPane3 = new JScrollPane(this.maCanvas, 20, 30);
        jScrollPane3.getViewport().setBackground(Color.RED);
        jScrollPane3.setPreferredSize(new Dimension(600, 400));
        JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, jScrollPane3);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setDividerLocation(400);
        jSplitPane2.setContinuousLayout(true);
        MessageArea.Instance().setPreferredSize(new Dimension(600, 50));
        JSplitPane jSplitPane3 = new JSplitPane(0, jSplitPane2, MessageArea.Instance());
        jSplitPane3.setOneTouchExpandable(true);
        jSplitPane3.setContinuousLayout(true);
        this.addGridElement(jSplitPane3, 0, 0, 2, 1, 3, 3, 10, 1);
        this.maButtonBar = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.maButtonBar.setLayout(new FlowLayout());
        this.addGridElement(this.maButtonBar, 0, 3, 2, 1, 1, 0, 17, 2);
        this.maExpandButton = this.createButton("Expand All", "expand");
        this.maQuitButton = this.createButton("Quit", "quit");
        this.UpdateButtonStates();
        this.setJMenuBar(this.CreateMenuBar());
        this.setTitle("Accessibility Workbench v1.9");
        this.setVisible(true);
        this.pack();
        jSplitPane3.setDividerLocation(1.0);
        this.validate();
        this.repaint();
    }

    void addGridElement(JComponent jComponent, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.anchor = n7;
        gridBagConstraints.fill = n8;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
    }

    public JButton createButton(String string, String string2) {
        JButton jButton = new JButton(string);
        jButton.setEnabled(false);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        this.maButtonBar.add(jButton);
        return jButton;
    }

    JMenuBar CreateMenuBar() {
        this.maMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        this.maMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Quit");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        JMenu jMenu2 = new JMenu("View");
        this.maMenuBar.add(jMenu2);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = Options.GetInteger("ZoomMode", -1);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Whole Screen", n == -1);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("200%", n == 200);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("100%", n == 100);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("50%", n == 50);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("25%", n == 25);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("10%", n == 10);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        JMenu jMenu3 = new JMenu("Options");
        this.maMenuBar.add(jMenu3);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Descriptions", Options.GetBoolean("ShowDescriptions"));
        jMenu3.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(this);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Names", Options.GetBoolean("ShowNames"));
        jMenu3.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(this);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Text", Options.GetBoolean("ShowText"));
        jMenu3.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(this);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Antialiased Rendering", Options.GetBoolean("Antialiasing"));
        jMenu3.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(this);
        JMenu jMenu4 = new JMenu("Help");
        this.maMenuBar.add(jMenu4);
        jMenuItem = new JMenuItem("Help");
        jMenu4.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("News");
        jMenu4.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("About");
        jMenu4.add(jMenuItem);
        jMenuItem.addActionListener(this);
        return this.maMenuBar;
    }

    protected void Initialize() {
        this.maCanvas.SetTree(this.maTree);
        SimpleOffice simpleOffice = SimpleOffice.Instance();
        if (simpleOffice != null && simpleOffice.GetDesktop() != null) {
            simpleOffice.GetDesktop().addTerminateListener((XTerminateListener)this);
        }
        this.mbInitialized = true;
        this.UpdateButtonStates();
    }

    protected void UpdateButtonStates() {
        this.maQuitButton.setEnabled(true);
        this.maExpandButton.setEnabled(this.mbInitialized);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("connect")) {
            SimpleOffice.Clear();
            this.Initialize();
        } else if (string.equals("quit")) {
            this.Quit();
        } else if (string.equals("update")) {
            this.Initialize();
        } else if (string.equals("shapes")) {
            Cursor cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            this.setCursor(cursor);
        } else if (string.equals("expand")) {
            Cursor cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            for (int i = 0; i < this.maTree.getRowCount(); ++i) {
                this.maTree.expandRow(i);
            }
            this.setCursor(cursor);
        } else if (string.equals("Quit")) {
            System.out.println("exiting");
            System.exit(0);
        } else if (string.equals("Show Descriptions")) {
            Options.SetBoolean("ShowDescriptions", ((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            this.maCanvas.repaint();
        } else if (string.equals("Show Names")) {
            Options.SetBoolean("ShowNames", ((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            this.maCanvas.repaint();
        } else if (string.equals("Show Text")) {
            Options.SetBoolean("ShowText", ((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            this.maCanvas.repaint();
        } else if (string.equals("Antialiased Rendering")) {
            Options.SetBoolean("Antialiasing", ((JCheckBoxMenuItem)actionEvent.getSource()).getState());
            this.maCanvas.repaint();
        } else if (string.equals("Help")) {
            HelpWindow.Instance().loadFile("help.html");
        } else if (string.equals("News")) {
            try {
                HelpWindow.Instance().loadFile("news.html");
            }
            catch (Exception exception) {}
        } else if (string.equals("About")) {
            HelpWindow.Instance().loadFile("about.html");
        } else if (string.equals("Whole Screen")) {
            Options.SetInteger("ZoomMode", -1);
            this.maCanvas.repaint();
        } else if (string.equals("200%")) {
            Options.SetInteger("ZoomMode", 200);
            this.maCanvas.repaint();
        } else if (string.equals("100%")) {
            Options.SetInteger("ZoomMode", 100);
            this.maCanvas.repaint();
        } else if (string.equals("50%")) {
            Options.SetInteger("ZoomMode", 50);
            this.maCanvas.repaint();
        } else if (string.equals("25%")) {
            Options.SetInteger("ZoomMode", 25);
            this.maCanvas.repaint();
        } else if (string.equals("10%")) {
            Options.SetInteger("ZoomMode", 10);
            this.maCanvas.repaint();
        } else if (string.equals("<connected>")) {
            this.Connected();
        } else if (string.equals("CreateNewViewWindow")) {
            TreeNode treeNode;
            TreePath treePath = this.maTree.getSelectionPath();
            if (treePath != null && (treeNode = (TreeNode)treePath.getLastPathComponent()) instanceof XAccessible) {
                new ObjectViewContainerWindow(((XAccessible)treeNode).getAccessibleContext());
            }
        } else {
            System.err.println("unknown command " + string);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.isAddedPath()) {
            Cursor cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            TreePath treePath = treeSelectionEvent.getPath();
            this.maTree.scrollPathToVisible(treePath);
            Object object = treePath.getLastPathComponent();
            this.implSetCurrentObject(object);
            if (object instanceof XAccessible && this.maObjectViewContainer != null) {
                this.maObjectViewContainer.SetObject(((XAccessible)object).getAccessibleContext());
            }
            if (this.maCanvas != null) {
                this.maCanvas.SelectObject((TreeNode)object);
            }
            this.setCursor(cursor);
        } else {
            this.implSetCurrentObject(treeSelectionEvent.getPath().getLastPathComponent());
            if (this.maObjectViewContainer != null) {
                this.maObjectViewContainer.SetObject(null);
            }
            if (this.maCanvas != null) {
                this.maCanvas.SelectObject(null);
            }
        }
    }

    private void implSetCurrentObject(Object object) {
        if (this.maObjectViewContainer == null) {
            return;
        }
        if (this.maCurrentObject != null) {
            AccessibilityModel.removeEventListener((TreeNode)this.maCurrentObject, this.maObjectViewContainer);
        }
        this.maCurrentObject = object;
        if (this.maCurrentObject != null) {
            AccessibilityModel.addEventListener((TreeNode)this.maCurrentObject, this.maObjectViewContainer);
        }
    }

    public void disposing(EventObject eventObject) {
        XFrame xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)eventObject.Source);
        if (xFrame != null) {
            System.out.println("frame disposed");
        } else {
            System.out.println("controller disposed");
        }
    }

    public void queryTermination(EventObject eventObject) throws TerminationVetoException {
        System.out.println("Terminate Event : " + eventObject);
    }

    public void notifyTermination(EventObject eventObject) {
        System.out.println("Notifiy Termination Event : " + eventObject);
    }

    private void Connected() {
        XExtendedToolkit xExtendedToolkit = SimpleOffice.Instance().GetExtendedToolkit();
        if (xExtendedToolkit != null) {
            this.maTree.setToolkit(xExtendedToolkit);
        }
    }

    private void Quit() {
        System.exit(0);
    }
}

