/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcBlob;
import org.hsqldb.jdbc.jdbcClob;
import org.hsqldb.jdbc.jdbcResultSetMetaData;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.lib.AsciiStringInputStream;
import org.hsqldb.lib.StringInputStream;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class jdbcResultSet
implements ResultSet {
    boolean autoClose;
    public Result rResult;
    private Record nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    int iColumnCount;
    private boolean bWasNull;
    private ResultSetMetaData rsmd;
    private HsqlProperties connProperties;
    private boolean isNetConn;
    jdbcStatement sqlStatement;
    int rsType = 1003;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;

    @Override
    public boolean next() throws SQLException {
        this.bWasNull = false;
        if (this.rResult == null || this.rResult.isEmpty()) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.rRoot;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            if (this.nCurrent == null) {
                return false;
            }
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = this.rResult.getSize() + 1;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws SQLException {
        this.iUpdateCount = -1;
        this.rResult = null;
        if (this.autoClose) {
            this.sqlStatement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.bWasNull;
    }

    @Override
    public String getString(int n) throws SQLException {
        return (String)this.getColumnInType(n, 1);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumnInType(n, 16);
        return object == null ? false : (Boolean)object;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        Object object = this.getColumnInType(n, -6);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public short getShort(int n) throws SQLException {
        Object object = this.getColumnInType(n, 5);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public int getInt(int n) throws SQLException {
        Object object = this.getColumnInType(n, 4);
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public long getLong(int n) throws SQLException {
        Object object = this.getColumnInType(n, -5);
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Object object = this.getColumnInType(n, 7);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Object object = this.getColumnInType(n, 8);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getColumnInType(n, 3);
        if (n2 < 0) {
            throw Util.sqlException(62);
        }
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 5);
        }
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        object = this.getColumnInType(n, -2);
        return (byte[])object;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return (Date)this.getColumnInType(n, 91);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return (Time)this.getColumnInType(n, 92);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getColumnInType(n, 93);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new AsciiStringInputStream(string);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringInputStream(string);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return this.wasNull() ? null : new ByteArrayInputStream(byArray);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.rsmd == null) {
            this.rsmd = new jdbcResultSetMetaData(this, this.connProperties);
        }
        return this.rsmd;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        int n2;
        Object object;
        this.checkAvailable();
        try {
            object = this.nCurrent.data[--n];
            n2 = this.rResult.metaData.colTypes[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Util.sqlException(28, String.valueOf(++n));
        }
        if (this.checkNull(object)) {
            return null;
        }
        switch (n2) {
            case 91: {
                return new Date(((Date)object).getTime());
            }
            case 92: {
                return new Time(((Time)object).getTime());
            }
            case 93: {
                long l = ((Timestamp)object).getTime();
                int n3 = ((Timestamp)object).getNanos();
                Timestamp timestamp = new Timestamp(l);
                timestamp.setNanos(n3);
                return timestamp;
            }
            case 1111: 
            case 2000: {
                try {
                    return ((JavaObject)object).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw Util.sqlException(Trace.error(18));
                }
            }
            case -4: 
            case -3: 
            case -2: {
                return ((Binary)object).getClonedBytes();
            }
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        for (int i = 0; i < this.iColumnCount; ++i) {
            String string2 = this.rResult.metaData.colLabels[i];
            if (!string.equalsIgnoreCase(string2)) continue;
            return i + 1;
        }
        throw Util.sqlException(28, string);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.getColumnInType(n, 3);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.rResult.rRoot != null && !this.bInit;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        return this.rResult.rRoot != null && this.bInit && this.nCurrent == null;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.iCurrentRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        return this.rResult.rRoot != null && this.bInit && this.nCurrent != null && this.nCurrent.next == null;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        this.bInit = false;
        this.nCurrent = null;
        this.iCurrentRow = 0;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult != null && this.rResult.rRoot != null) {
            this.bInit = true;
            this.iCurrentRow = this.rResult.getSize() + 1;
            this.nCurrent = null;
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        this.bInit = false;
        if (this.rResult.rRoot != null) {
            this.bInit = true;
            this.nCurrent = this.rResult.rRoot;
            this.iCurrentRow = 1;
        }
        return this.bInit;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (!this.bInit || this.nCurrent == null) {
            this.first();
        }
        while (this.nCurrent.next != null) {
            ++this.iCurrentRow;
            this.nCurrent = this.nCurrent.next;
        }
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return this.iCurrentRow;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null || n == 0) {
            return false;
        }
        switch (n) {
            case 1: {
                return this.first();
            }
            case -1: {
                return this.last();
            }
        }
        if (n < 0) {
            this.last();
            n = this.iCurrentRow + n + 1;
            if (n <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (n < this.iCurrentRow || this.iCurrentRow == 0) {
            this.beforeFirst();
        }
        while (n > this.iCurrentRow) {
            this.next();
            if (this.nCurrent != null) continue;
        }
        return this.nCurrent != null;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (n < 0) {
            n = this.iCurrentRow + n;
            this.beforeFirst();
            if (n <= 0) {
                return false;
            }
        }
        while (n-- > 0) {
            this.next();
            if (this.nCurrent != null) continue;
        }
        return this.nCurrent != null;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        if (this.getType() == 1003) {
            throw Util.sqlException(51);
        }
        if (this.rResult == null || this.rResult.rRoot == null || this.iCurrentRow == 0) {
            return false;
        }
        if (this.bInit && this.nCurrent == null) {
            return this.last();
        }
        int n = this.iCurrentRow - 1;
        if (n == 0) {
            this.beforeFirst();
            return false;
        }
        this.first();
        while (n != this.iCurrentRow) {
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        return this.nCurrent != null;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        if (this.rsType == 1003 && n != 1000) {
            throw Util.notSupported();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw Util.sqlException(62);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.rsType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRow() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.sqlStatement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : new jdbcBlob(byArray);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        String string = this.getString(n);
        return string == null ? null : new jdbcClob(string);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw Util.notSupported();
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        if (calendar == null) {
            return date;
        }
        calendar.setTime(date);
        HsqlDateTime.resetToDate(calendar);
        return new Date(calendar.getTime().getTime());
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        if (calendar == null) {
            return time;
        }
        calendar.setTime(time);
        HsqlDateTime.resetToTime(calendar);
        return new Time(calendar.getTime().getTime());
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (calendar != null && timestamp != null) {
            timestamp.setTime(HsqlDateTime.getTimeInMillis(timestamp, null, calendar));
        }
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw Util.notSupported();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw Util.notSupported();
    }

    private void checkAvailable() throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            throw Util.sqlException(35);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.rResult == null || this.sqlStatement != null && this.sqlStatement.isClosed) {
            throw Util.sqlException(158);
        }
    }

    void checkColumn(int n) throws SQLException {
        if (n < 1 || n > this.iColumnCount) {
            throw Util.sqlException(28, String.valueOf(n));
        }
    }

    private boolean checkNull(Object object) {
        if (object == null) {
            this.bWasNull = true;
            return true;
        }
        this.bWasNull = false;
        return false;
    }

    private Object getColumnInType(int n, int n2) throws SQLException {
        Object object;
        int n3;
        this.checkAvailable();
        try {
            n3 = this.rResult.metaData.colTypes[--n];
            object = this.nCurrent.data[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Util.sqlException(28, String.valueOf(++n));
        }
        if (this.checkNull(object)) {
            return null;
        }
        if (n3 != n2) {
            if (object instanceof Binary && n2 != 1) {
                throw Util.sqlException(16);
            }
            try {
                object = Column.convertObject(object, n2);
            }
            catch (Exception exception) {
                String string = "type: " + Types.getTypeString(n3) + " (" + n3 + ") expected: " + Types.getTypeString(n2) + " value: " + object.toString();
                throw Util.sqlException(16, string);
            }
        }
        switch (n2) {
            case 91: {
                return new Date(((Date)object).getTime());
            }
            case 92: {
                return new Time(((Time)object).getTime());
            }
            case 93: {
                long l = ((Timestamp)object).getTime();
                int n4 = ((Timestamp)object).getNanos();
                Timestamp timestamp = new Timestamp(l);
                timestamp.setNanos(n4);
                return timestamp;
            }
        }
        return object;
    }

    jdbcResultSet(jdbcStatement jdbcStatement2, Result result, HsqlProperties hsqlProperties, boolean bl) throws SQLException {
        this.sqlStatement = jdbcStatement2;
        this.connProperties = hsqlProperties;
        this.isNetConn = bl;
        if (result.mode == 1) {
            this.iUpdateCount = result.getUpdateCount();
        } else if (result.isError()) {
            Util.throwError(result);
        } else {
            if (jdbcStatement2 != null) {
                this.rsType = jdbcStatement2.rsType;
            }
            this.iUpdateCount = -1;
            this.rResult = result;
            this.iColumnCount = result.getColumnCount();
        }
        this.bWasNull = false;
    }

    int getUpdateCount() {
        return this.iUpdateCount;
    }

    boolean isResult() {
        return this.rResult != null;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        return (T)this.getObject(n);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }
}

