/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.SectionFileLink;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;

public class TextSectionHandler {
    public XTextSectionsSupplier xTextSectionsSupplier;
    private XMultiServiceFactory xMSFDoc;
    private XTextDocument xTextDocument;
    private XText xText;

    public TextSectionHandler(XMultiServiceFactory xMultiServiceFactory, XTextDocument xTextDocument) {
        this.xMSFDoc = xMultiServiceFactory;
        this.xTextDocument = xTextDocument;
        this.xText = xTextDocument.getText();
        this.xTextSectionsSupplier = (XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)xTextDocument);
    }

    public void removeTextSectionbyName(String string) {
        try {
            XNameAccess xNameAccess = this.xTextSectionsSupplier.getTextSections();
            if (xNameAccess.hasByName(string)) {
                Object object = this.xTextSectionsSupplier.getTextSections().getByName(string);
                this.removeTextSection(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public boolean hasTextSectionByName(String string) {
        XNameAccess xNameAccess = this.xTextSectionsSupplier.getTextSections();
        return xNameAccess.hasByName(string);
    }

    public void removeLastTextSection() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextSectionsSupplier.getTextSections());
            Object object = xIndexAccess.getByIndex(xIndexAccess.getCount() - 1);
            this.removeTextSection(object);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void removeTextSection(Object object) {
        try {
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)object);
            this.xText.removeTextContent(xTextContent);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void removeInvisibleTextSections() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextSectionsSupplier.getTextSections());
            int n = xIndexAccess.getCount();
            for (int i = n - 1; i >= 0; --i) {
                boolean bl;
                XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xIndexAccess.getByIndex(i));
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextContent);
                boolean bl2 = bl = !AnyConverter.toBoolean((Object)xPropertySet.getPropertyValue("IsVisible"));
                if (!bl) continue;
                this.xText.removeTextContent(xTextContent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void removeAllTextSections() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextSectionsSupplier.getTextSections());
            int n = xIndexAccess.getCount();
            for (int i = n - 1; i >= 0; --i) {
                XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)xIndexAccess.getByIndex(i));
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextContent);
                this.xText.removeTextContent(xTextContent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void breakLinkofTextSections() {
        try {
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.xTextSectionsSupplier.getTextSections());
            int n = xIndexAccess.getCount();
            SectionFileLink sectionFileLink = new SectionFileLink();
            sectionFileLink.FileURL = PropertyNames.EMPTY_STRING;
            for (int i = 0; i < n; ++i) {
                Object object = xIndexAccess.getByIndex(i);
                Helper.setUnoPropertyValues(object, new String[]{"FileLink", "LinkRegion"}, new Object[]{sectionFileLink, PropertyNames.EMPTY_STRING});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void breakLinkOfTextSection(Object object) {
        SectionFileLink sectionFileLink = new SectionFileLink();
        sectionFileLink.FileURL = PropertyNames.EMPTY_STRING;
        Helper.setUnoPropertyValues(object, new String[]{"FileLink", "LinkRegion"}, new Object[]{sectionFileLink, PropertyNames.EMPTY_STRING});
    }

    public void linkSectiontoTemplate(String string, String string2) {
        try {
            Object object = this.xTextSectionsSupplier.getTextSections().getByName(string2);
            this.linkSectiontoTemplate(object, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void linkSectiontoTemplate(Object object, String string, String string2) {
        SectionFileLink sectionFileLink = new SectionFileLink();
        sectionFileLink.FileURL = string;
        Helper.setUnoPropertyValues(object, new String[]{"FileLink", "LinkRegion"}, new Object[]{sectionFileLink, string2});
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface(XNamed.class, (Object)object);
        String string3 = xNamed.getName();
        if (string3.compareTo(string2) != 0) {
            xNamed.setName(string2);
        }
    }

    public void insertTextSection(String string, String string2, boolean bl) {
        try {
            XTextCursor xTextCursor;
            if (bl) {
                xTextCursor = this.xText.createTextCursor();
                this.xText.insertControlCharacter((XTextRange)xTextCursor, (short)0, false);
                xTextCursor.collapseToEnd();
            }
            xTextCursor = this.xText.createTextCursor();
            xTextCursor.gotoEnd(false);
            this.insertTextSection(string, string2, xTextCursor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.out);
        }
    }

    public void insertTextSection(String string, String string2, XTextCursor xTextCursor) {
        try {
            Object object;
            if (this.xTextSectionsSupplier.getTextSections().hasByName(string)) {
                object = this.xTextSectionsSupplier.getTextSections().getByName(string);
            } else {
                object = this.xMSFDoc.createInstance("com.sun.star.text.TextSection");
                XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)object);
                xTextCursor.getText().insertTextContent((XTextRange)xTextCursor, xTextContent, false);
            }
            this.linkSectiontoTemplate(object, string2, string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

