/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.query;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.QueryMetaData;
import com.sun.star.wizards.ui.FilterComponent;

public class QuerySummary
extends QueryMetaData {
    private String sSummary;
    private Resource oResource;
    private final String sSeparator;
    private final String sReturnChar;
    private final String sAnd;
    private final String sOr;

    public QuerySummary(XMultiServiceFactory _xMSF, Resource _oResource) {
        super(_xMSF);
        this.oResource = _oResource;
        this.sAnd = this.oResource.getResText("RID_QUERY_38");
        this.sOr = this.oResource.getResText("RID_QUERY_39");
        this.sSeparator = this.oResource.getResText("RID_QUERY_91");
        this.sReturnChar = String.valueOf('\r') + String.valueOf('\r');
    }

    public void setSummaryString() {
        try {
            String sFieldNamesFraction = PropertyNames.EMPTY_STRING;
            String sSortingFraction = PropertyNames.EMPTY_STRING;
            String sFilterFraction = PropertyNames.EMPTY_STRING;
            String sAggregateFraction = PropertyNames.EMPTY_STRING;
            String sGroupByFraction = PropertyNames.EMPTY_STRING;
            String sHavingFraction = PropertyNames.EMPTY_STRING;
            sFieldNamesFraction = this.combineFieldNameFraction() + this.sReturnChar;
            sSortingFraction = this.combinePartString("RID_QUERY_51", this.getSortFieldNames(), "RID_QUERY_52", "RID_QUERY_93", new String[]{"<FIELDNAME>", "<SORTMODE>"}) + this.sReturnChar;
            sFilterFraction = this.combineFilterNameFraction(this.getFilterConditions(), "RID_QUERY_53", "RID_QUERY_54") + this.sReturnChar;
            if (this.getDBMetaData().supportsGroupBy()) {
                sGroupByFraction = this.combinePartString("RID_QUERY_57", this.getGroupFieldNames(), "RID_QUERY_58") + this.sReturnChar;
                sHavingFraction = this.combineFilterNameFraction(this.getGroupByFilterConditions(), "RID_QUERY_59", "RID_QUERY_60");
            }
            this.sSummary = sFieldNamesFraction + sSortingFraction + sFilterFraction + sAggregateFraction + sGroupByFraction + sHavingFraction;
            this.sSummary = JavaTools.replaceSubString((String)this.sSummary, (String)PropertyNames.EMPTY_STRING, (String)"~");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public String getSummaryString() {
        return this.sSummary;
    }

    private String combineFilterNameFraction(PropertyValue[][] _filterconditions, String _InitResID, String _AlternativeResID) {
        if (_filterconditions != null && _filterconditions.length > 0) {
            String sconditions = PropertyNames.EMPTY_STRING;
            String sStart = this.oResource.getResText(_InitResID);
            String BaseString = this.oResource.getResText("RID_QUERY_96");
            if (_filterconditions.length == 1) {
                PropertyValue[] curfilterconditions = _filterconditions[0];
                for (int i = 0; i < curfilterconditions.length; ++i) {
                    sconditions = sconditions + FilterComponent.getDisplayCondition((String)BaseString, (PropertyValue)_filterconditions[0][i], (QueryMetaData)this);
                    sconditions = this.appendClauseSeparator(sconditions, PropertyNames.SPACE + this.sAnd + PropertyNames.SPACE, i, curfilterconditions.length);
                }
            } else {
                for (int i = 0; i < _filterconditions.length; ++i) {
                    sconditions = sconditions + FilterComponent.getDisplayCondition((String)BaseString, (PropertyValue)_filterconditions[i][0], (QueryMetaData)this);
                    sconditions = this.appendClauseSeparator(sconditions, PropertyNames.SPACE + this.sOr + PropertyNames.SPACE, i, _filterconditions.length);
                }
            }
            return sStart + sconditions;
        }
        return this.oResource.getResText(_AlternativeResID);
    }

    private String combineFieldNameFraction() {
        String CurString = PropertyNames.EMPTY_STRING;
        String sReturn = this.oResource.getResText("RID_QUERY_50");
        String BaseString = this.oResource.getResText("RID_QUERY_92");
        for (int i = 0; i < this.FieldColumns.length; ++i) {
            CurString = BaseString;
            FieldColumn CurDBFieldColumn = super.getFieldColumnByDisplayName(this.FieldColumns[i].getDisplayFieldName());
            int iAggregate = this.getAggregateIndex(this.FieldColumns[i].getFieldName());
            if (iAggregate > -1) {
                String sAggregateDisplay = this.AggregateFieldNames[iAggregate][1] + "(" + this.AggregateFieldNames[iAggregate][0] + ")";
                CurString = JavaTools.replaceSubString((String)CurString, (String)sAggregateDisplay, (String)"<FIELDNAME>");
            } else {
                CurString = JavaTools.replaceSubString((String)CurString, (String)CurDBFieldColumn.getDisplayFieldName(), (String)"<FIELDNAME>");
            }
            sReturn = sReturn + JavaTools.replaceSubString((String)CurString, (String)CurDBFieldColumn.getFieldTitle(), (String)"<FIELDTITLE>");
            sReturn = this.appendClauseSeparator(sReturn, this.sSeparator, i, this.FieldColumns.length);
        }
        return sReturn;
    }

    private String appendClauseSeparator(String _basestring, String _suffix, int _i, int _fieldcount) {
        if (_i < _fieldcount - 1) {
            _basestring = _basestring + _suffix;
        }
        return _basestring;
    }

    private String combinePartString(String _InitResID, String[] _FieldNames, String _AlternativeResID) {
        if (_FieldNames != null && _FieldNames.length > 0) {
            return this.ArrayFieldsToString(_InitResID, _FieldNames);
        }
        return this.oResource.getResText(_AlternativeResID);
    }

    private String ArrayFieldsToString(String _InitResID, String[] _FieldNames) {
        StringBuilder sReturn = new StringBuilder(this.oResource.getResText(_InitResID));
        int FieldCount = _FieldNames.length;
        for (int i = 0; i < FieldCount; ++i) {
            sReturn.append(this.getFieldColumnByDisplayName(_FieldNames[i]).getFieldTitle());
            if (i >= FieldCount - 1) continue;
            sReturn.append(this.sSeparator);
        }
        return sReturn.toString();
    }

    private String combinePartString(String _InitResID, String[][] _FieldNames, String _AlternativeResID, String _BaseStringID, String[] _ReplaceTags) {
        if (_FieldNames != null && _FieldNames.length > 0) {
            return this.ArrayFieldsToString(_InitResID, _FieldNames, _BaseStringID, _ReplaceTags);
        }
        return this.oResource.getResText(_AlternativeResID);
    }

    private String ArrayFieldsToString(String _InitResID, String[][] _FieldNames, String _BaseStringID, String[] _ReplaceTags) {
        String CurString = PropertyNames.EMPTY_STRING;
        StringBuilder sReturn = new StringBuilder(this.oResource.getResText(_InitResID));
        int FieldCount = _FieldNames.length;
        if (FieldCount > 0) {
            int DimCount = _FieldNames[0].length;
            String BaseString = this.oResource.getResText(_BaseStringID);
            for (int i = 0; i < FieldCount; ++i) {
                for (int a = 0; a < DimCount; ++a) {
                    if (a == 0) {
                        int iAggregate = this.getAggregateIndex(this.getFieldColumnByDisplayName(_FieldNames[i][a]).getDisplayFieldName());
                        if (iAggregate > -1) {
                            String sAggregateDisplay = this.AggregateFieldNames[iAggregate][1] + "(" + this.AggregateFieldNames[iAggregate][0] + ")";
                            CurString = JavaTools.replaceSubString((String)BaseString, (String)sAggregateDisplay, (String)_ReplaceTags[a]);
                            continue;
                        }
                        CurString = JavaTools.replaceSubString((String)BaseString, (String)this.getFieldColumnByDisplayName(_FieldNames[i][a]).getFieldTitle(), (String)_ReplaceTags[a]);
                        continue;
                    }
                    CurString = JavaTools.replaceSubString((String)CurString, (String)_FieldNames[i][a], (String)_ReplaceTags[a]);
                }
                sReturn.append(CurString);
                if (i >= FieldCount - 1) continue;
                sReturn.append(this.sSeparator);
            }
        }
        return sReturn.toString();
    }
}

