/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.TypeInspector;

public class ColumnPropertySet {
    private TypeInspector oTypeInspector;
    private XPropertySet xPropertySet;
    private int nType;
    private String sTypeName = PropertyNames.EMPTY_STRING;

    public ColumnPropertySet(TypeInspector _oTypeInspector, XPropertySet _xPropertySet) {
        this.xPropertySet = _xPropertySet;
        this.oTypeInspector = _oTypeInspector;
    }

    public XPropertySet getPropertySet() {
        return this.xPropertySet;
    }

    private void assignPropertyValues(String _sNewName, PropertyValue[] _aNewColPropertyValues, boolean _bsetDefaultProperties) {
        try {
            this.nType = (Integer)Properties.getPropertyValue(_aNewColPropertyValues, "Type");
            this.nType = this.oTypeInspector.convertDataType(this.nType);
            if (Properties.hasPropertyValue(_aNewColPropertyValues, "TypeName")) {
                this.sTypeName = (String)Properties.getPropertyValue(_aNewColPropertyValues, "TypeName");
            }
            Integer precision = null;
            if (Properties.hasPropertyValue(_aNewColPropertyValues, "Precision")) {
                precision = (Integer)Properties.getPropertyValue(_aNewColPropertyValues, "Precision");
            }
            if (this.nType == 12 && (precision == null || precision == 0)) {
                precision = 50;
            }
            if (precision != null) {
                this.xPropertySet.setPropertyValue("Precision", (Object)precision);
            }
            this.setType(this.sTypeName, precision);
            for (int i = 0; i < _aNewColPropertyValues.length; ++i) {
                String sPropName = _aNewColPropertyValues[i].Name;
                if (_sNewName != null && sPropName.equals(PropertyNames.PROPERTY_NAME)) {
                    this.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)_sNewName);
                    continue;
                }
                if (sPropName.equals("Precision") || sPropName.equals("Type") || sPropName.equals("TypeName")) continue;
                Object oColValue = _aNewColPropertyValues[i].Value;
                this.assignPropertyValue(sPropName, oColValue);
            }
            if (_bsetDefaultProperties) {
                this.assignPropertyValue("IsNullable", this.oTypeInspector.isNullable(this.xPropertySet));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void assignPropertyValues(PropertyValue[] _aNewColPropertyValues, boolean _bsetDefaultProperties) {
        this.assignPropertyValues(null, _aNewColPropertyValues, _bsetDefaultProperties);
    }

    private void setType(String _sTypeName, Integer precision) {
        this.sTypeName = _sTypeName.equals(PropertyNames.EMPTY_STRING) ? this.oTypeInspector.getDefaultTypeName(this.nType, precision) : _sTypeName;
        this.nType = this.oTypeInspector.getDataType(this.sTypeName);
        this.assignPropertyValue("Type", this.nType);
        this.assignPropertyValue("TypeName", this.sTypeName);
    }

    private void assignPropertyValue(String _spropname, Object _oValue) {
        try {
            if (_spropname.equals("Type")) {
                this.nType = (Integer)_oValue;
                this.xPropertySet.setPropertyValue("Type", (Object)this.nType);
            } else if (_spropname.equals(PropertyNames.PROPERTY_NAME)) {
                String sName = (String)_oValue;
                if (!sName.equals(PropertyNames.EMPTY_STRING)) {
                    this.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)sName);
                }
            } else if (_spropname.equals("Scale")) {
                int nScale = (Integer)_oValue;
                nScale = this.oTypeInspector.getScale(this.xPropertySet);
                this.xPropertySet.setPropertyValue("Scale", (Object)nScale);
            } else if (_spropname.equals("IsNullable")) {
                int nNullability = (Integer)_oValue;
                nNullability = this.oTypeInspector.getNullability(this.xPropertySet, nNullability);
                this.xPropertySet.setPropertyValue("IsNullable", (Object)nNullability);
            } else if (_spropname.equals("TypeName")) {
                String sTypeName = (String)_oValue;
                this.xPropertySet.setPropertyValue("TypeName", (Object)sTypeName);
            } else {
                this.xPropertySet.setPropertyValue(_spropname, _oValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

